import React from 'react'
import { View, Text, TextInput, StyleSheet, ScrollView, Alert, TouchableOpacity, Button } from 'react-native'
import { Card } from 'react-native-shadow-cards'
import { connect } from 'react-redux'
import Axios from 'axios'

class TransactionDetail extends React.Component {
    constructor(props) {
        super(props)
        this.state = {
            transDetail: [],
            trans_date: '',
            transDiscount: '',
            transId: '',
            transTax: '',
            transTotal: '',
            trans_type_display: '',
            outlet: '',
            outlet_code: '',
            trans_time: '',
            trans_total: '',
            point_reduce: '',
            transaction_detail: []
        }
    }

    componentDidMount() {
        this.getDetailTrans()
    }

    getDetailTrans() {
        let params = {
            session_id: this.props.session_id,
            transaction_id: this.props.route.params.idTrans
        }
        Axios.post('https://excelsocrm.ravintoladev.com/crm/v2/transaction/detail', params).then(res => {
            console.log("INI DATA NYA LHOOOOO ......." + JSON.stringify(res.data))
            let data = res.data
            console.log(data)
            this.setState({
                trans_type_display: data.trans_type_display,
                transId: data.trans_id,
                trans_date: data.trans_date,
                transTotal: data.trans_total,
                outlet: data.outlet,
                outlet_code: data.outlet_code,
                trans_time: data.trans_time,
                trans_total: data.trans_total,
                point_reduce: data.point_reduce,
                transaction_detail: data.transaction_detail
            })
            // console.log(this.state.history_list)
        })
    }

    render() {
        return (
            <View style={styles.container}>
                <View style={styles.header}>
                    <Text style={{ textAlign: 'center', margin: 20, fontSize: 25, alignSelf: 'center' }}>Transaction Detail</Text>
                </View>
                <View style={styles.body}>
                    <Card style={{ padding: 10, margin: 10, alignContent: 'center' }}>
                        <Text> Jenis Transaksi : {this.state.trans_type_display}</Text>
                        <Text> Tanggal : {this.state.trans_date}</Text>
                        <Text> Total : {this.state.transTotal}</Text>
                        <Text> Waktu Transaksi  : {this.state.trans_time}</Text>
                        <Text> Poin reduce : {this.state.point_reduce}</Text>
                        <Text> Total : {this.state.outlet_code}</Text>
                        <Text> Total : {this.state.outlet_code}</Text>
                    </Card>

                    <Card style={{ padding: 10, margin: 10, alignContent: 'center' }}>
                        {
                            this.state.transaction_detail.map((item, index) => {
                                return (
                                    <View key={index}>
                                        <Text>NAMA ITEM : {item.item_name}</Text>
                                        <Text>QTY : {item.item_quantity}</Text>
                                        <Text>PRICE  : {item.item_price}</Text>
                                        <Text>DISCOUNT : {item.item_discount}</Text>
                                        <View style={{ borderWidth: 1, margin: 10 }}></View>
                                        <Text>TOTAL : {item.item_subtotal}</Text>
                                    </View>
                                )
                            })
                        }

                    </Card>

                </View>
            </View>
        )
    }
}

const styles = StyleSheet.create({
    container: {
        flex: 1,
        backgroundColor: 'white',
    },
    header: {

        flex: 0.5,

    },

    body: {
        flex: 3,
        margin: 5,

    },
    list_detail_order: {
        flex: 1,
        margin: 20,
        borderWidth: 1,
    }
})

const mapStateToProps = (state) => {
    return {

        session_id: state.session_id,

    }
}

export default connect(mapStateToProps)(TransactionDetail)