import React from 'react';
import { View, Text, TextInput, StyleSheet, Button, Alert } from 'react-native';
import Axios from 'axios';
import { connect } from 'react-redux';
import ActionType from '../redux/globalActionType';

class TransferBalance extends React.Component {
    constructor(props) {
        super(props);
        this.state = {
            email: "",
            points: "",
            balance: "",
            img_card: "",
            member_since: "",
            account_number: "",
            destination: "",
            amount: "",
            reference: ""
        }
    }

    componentDidMount() {
        this.getBalance()
    }

    getBalance() {
        let params = {
            session_id: this.props.session_id
        }
        Axios.post('https://excelsocrm.ravintoladev.com/crm/v2/member/get_profile', params).then(res => {
            let data = res.data
            console.log('ini res nya : ' + data.kaspro_balance)
            this.setState({
                full_name: data.name,
                email: data.email,
                dob_day: data.dob_day,
                dob_month: data.dob_month,
                dob_year: data.dob_year,
                gender: data.gender_display,
                balance: data.kaspro_balance
            })
        }).catch(error => {
            let response = error.response.data;
            console.log(response.msg);
        })
    }

    handleSend() {
        let params = {
            "session_id": this.props.session_id,
            "destination": this.state.destination,
            "balance": this.state.amount,
            "reference": this.state.reference

        }
        console.log(params);
        Axios.post('https://excelsocrm.ravintoladev.com/crm/v2/card/transfer', params).then(res => {
            console.log('ini res ' + JSON.stringify(res.data))
            Alert.alert('Transaksi Berhasil')
            this.props.navigation.goBack()
        }).catch(error => {
            let response = error.response.data;
            Alert.alert(response.msg);
        })

    }

    // handle() {

    //     let cardProps = {
    //         set_card: false

    //     }
    //     this.props.setCardactive(cardProps)
    //     console.log(this.props.set_card)
    // }

    render() {
        return (
            <View style={styles.container}>
                <View style={styles.header}>
                    <Text style={{ textAlign: 'center', marginTop: 10, fontSize: 25 }}>Transfer Balance</Text>
                </View>
                <View style={styles.content}>
                    <View style={styles.name_addrees_input}>
                        <View style={styles.field_name_addrees}>
                            <View style={{ width: 55, justifyContent: 'center' }}>
                                <Text>Phone</Text>
                            </View>
                            <View style={{ flex: 1 }}>
                                <TextInput style={{ height: 40, borderWidth: 1, padding: 5, margin: 10 }}
                                    onChangeText={(destination) => this.setState({ destination })}
                                    value={this.state.destination}
                                    keyboardType='number-pad' />
                            </View>
                        </View>
                        <View style={styles.field_detail_addrees}>
                            <View style={{ width: 55, justifyContent: 'center' }}>
                                <Text>Amount</Text>
                            </View>
                            <View style={{ flex: 1 }}>
                                <TextInput style={{ height: 40, borderWidth: 1, padding: 5, margin: 10 }}
                                    onChangeText={(amount) => this.setState({ amount })}
                                    value={this.state.amount}
                                    keyboardType='number-pad'/>
                            </View>
                        </View>
                        <View style={styles.curent_balance}>
                            <View style={{ flex: 1, margin: 10 }}>
                                <Text style={{ fontSize: 20 }} >Current Balance </Text>
                            </View>
                            <View style={{ flex: 1, margin: 10 }}>
                                <Text style={{ fontSize: 20 }}>{this.state.balance}</Text>
                            </View>
                        </View>
                        <View style={styles.field_detail_addrees}>
                            <View style={{ width: 55, justifyContent: 'center' }}>
                                <Text>Reference</Text>
                            </View>
                            <View style={{ flex: 1 }}>
                                <TextInput style={{ height: 100, borderWidth: 1, padding: 5, margin: 10 }}
                                    onChangeText={(reference) => this.setState({ reference })}
                                    value={this.state.reference} />
                            </View>
                        </View>
                        {/* <View style={{ justifyContent: 'center', margin: 5 }}>
                            <Button title="Activate" onPress={() => this.handle()}></Button>
                        </View> */}
                        <View style={{ justifyContent: 'center' }} >
                            <Button title="SEND" onPress={() => this.handleSend()}></Button>
                        </View>
                    </View>
                </View>
            </View>
        )
    }
}

const styles = StyleSheet.create({

    container: {
        flex: 1,
        backgroundColor: '#ffff'
    },

    header: {
        flex: 0.5,
        margin: 5,
    },

    content: {
        flex: 3,
        margin: 5,
    },

    field_search: {
        flexDirection: 'row'
    },

    cont_google_map: {
        flex: 1,
        borderWidth: 1,
        margin: 5,
    },

    name_addrees_input: {
        flex: 1,
        margin: 5,
    },

    field_name_addrees: {
        flexDirection: 'row'
    },

    field_detail_addrees: {
        flexDirection: 'row'
    },

    button: {
        height: 40,
        margin: 10,

    },
    curent_balance: {
        flexDirection: 'row',
        margin: 10,
    },
})

const mapStateToProps = (state) => {
    return {
        session_id: state.session_id,
        set_card: state.set_card
    }
}

const mapDispatchToProps = (dispacth) => {
    console.log(dispacth)
    return {
        setCardactive: (cardProps) => dispacth({
            type: ActionType.SET_CARD,
            data: {
                set_card: cardProps.set_card,
            }
        }),
    }
}

export default connect(mapStateToProps, mapDispatchToProps)(TransferBalance);