import React from 'react';
import { View, Text, StyleSheet, Dimensions } from 'react-native';
import { Image } from 'react-native-elements';
import Axios from 'axios';
import { TouchableOpacity, ScrollView } from 'react-native-gesture-handler';
import HTML from 'react-native-render-html';

export default class NewsDetail extends React.Component {
    constructor(props) {
        super(props);
        this.state = {
            title: '',
            subtitle: '',
            image: '',
            content: '',
            image_height: 400
        }
    }

    componentDidMount() {
        const screenWidth = Math.round(Dimensions.get('window').width);
        this.setState({
          image_height: screenWidth
        })
        this.get_news_detail(this.props.route.params.slug)
    }

    get_news_detail(slug) {
        Axios.get('https://excelsocrm.ravintoladev.com/cms/v2/detail/' + slug).then(res => {
            // console.log(JSON.stringify(res.data))
            const detail = res.data;
            this.setState({
                title: detail.title,
                subtitle: detail.subtitle,
                image: detail.content_image,
                content: detail.content,
            })
        })
        
    }

    render() {
        console.log('Image : ' + this.state.image)
        return (
            <View style={styles.container}>
                <View style={styles.header}>
                    <TouchableOpacity onPress={() => this.props.navigation.goBack()}>
                    <Image source={require('../assets/icon/back.png')} style={{width: 35, height: 35}} />
                    </TouchableOpacity>
                    <Text style={styles.headerTitle}>NEWS DETAIL</Text>
                </View>
                <ScrollView style={styles.body}>
                    <View style={styles.image_container(this.state.image_height)}>
                        <Image style={styles.image(this.state.image_height)} source={this.state.image ? { uri: this.state.image } : null} />
                    </View>
                    <View style={styles.content}>
                        <Text style={styles.title}>{this.state.title}</Text>
                        <View style={{backgroundColor: '#adadad', height: 1.5, flex: 1, marginBottom: 5}} />
                        <HTML html={this.state.content} tagsStyles={{ p: {fontFamily: 'Gotham-Light', marginTop: 8, marginBottom: 8}, blockquote: { backgroundColor: "#f1f1f1", padding: 12, paddingBottom: 0, marginTop: 6 } }}/>
                    </View>
                </ScrollView>
            </View>
        )
    }
}


const styles = StyleSheet.create({
    container: {
        flex: 1,
        marginTop: 29,
        backgroundColor: 'white',
    },
    header: {
        height: 60,
        paddingHorizontal: 10,
        flexDirection: 'row',
        backgroundColor: '#CFB368',
        alignItems : 'center'
    },
    headerTitle: {
        flex: 1,
        textAlign: 'center', 
        margin: 20, 
        fontSize: 23, 
        alignSelf: 'center',
        color: 'white',
        fontFamily: 'Gotham-Black'
    },
    image_container: (height) => ({
        height: height,
        backgroundColor: 'gray'
    }),
    image: (height) => ({
        width: '100%',
        height: height
    }),
    title: {
        textAlign: 'center',
        fontFamily: 'Gotham-Black',
        fontSize: 22,
        marginBottom: 10,
        color: '#CFB368'
    },
    content: {
        paddingHorizontal: 25,
        paddingVertical: 30
    },
    body: {
    }
})

