import Axios from 'axios';
import Constants from 'expo-constants';
import { Alert } from 'react-native';
export default function CheckVersion(navigation) {
    let version = Constants.manifest.version
    
    Axios.get('https://excelso.ravintolavip.com/cms/v2/detail/apps-version').then(respon => {
        let version_server = respon.data.content5
        let msg_res = respon.data.content6
        if (version_server !== version) {

            Alert.alert(
                'Update Version',
                msg_res,
                [
                    {
                        text: 'Cancel',
                        onPress: () => console.log('Cancel Pressed'),
                        style: 'cancel'
                    },
                    { text: 'OK', onPress: () => navigation.navigate('UpdateVersion') }
                ],
                { cancelable: false }
            );
        }
    }).catch(error => {
        console.log(error)
    })
}