import React from 'react';
import { View, Text, TextInput, StyleSheet, Button, Alert, ScrollView, TouchableOpacity, Image } from 'react-native';
import Axios from 'axios';
import { connect } from 'react-redux';
import ActionType from '../redux/globalActionType';
import MyStatusBar from './MyStatusBar';
import i18n from 'i18n-js';
import Spinner from 'react-native-loading-spinner-overlay';
class TransferBalance extends React.Component {
    constructor(props) {
        super(props);
        this.state = {
            email: "",
            points: "",
            balance: "",
            img_card: "",
            member_since: "",
            account_number: "",
            destination: "",
            amount: "",
            reference: "",
            password: "",
            caretHidden: true,
            spinner: false,
        }
    }

    componentDidMount() {
        this.getBalance()
        console.log(this.props.BASE_URL);
    }

    getBalance() {
        let params = {
            session_id: this.props.session_id
        }
        Axios.post(this.props.BASE_URL + 'crm/v2/member/get_profile', params).then(res => {
            let data = res.data
            // console.log('ini res nya : ' + data.kaspro_balance)
            this.setState({
                full_name: data.name,
                email: data.email,
                dob_day: data.dob_day,
                dob_month: data.dob_month,
                dob_year: data.dob_year,
                gender: data.gender_display,
                balance: data.kaspro_balance
            })
        }).catch(error => {
            let response = error.response.data;
        })
    }

    handleSend() {
        this.setState({
            spinner: true,
        })
        let params = {
            "session_id": this.props.session_id,
            "destination": this.state.destination,
            "balance": this.state.amount,
            "reference": this.state.reference,
            "password": this.state.password

        }
        // console.log(params);
        Axios.post(this.props.BASE_URL + 'crm/v2/card/transfer', params).then(res => {
            // console.log('ini res ' + JSON.stringify(res.data))
            Alert.alert(i18n.t('alertSuccessTitle'), i18n.t('alertSuccessTransaction'))
            this.props.navigation.goBack()
            this.setState({
                spinner: false,
            })
        }).catch(error => {
            let response = error.response.data;
            Alert.alert('', response.msg);
            this.setState({
                spinner: false,
            })
        })

    }

    render() {
        return (
            <View style={styles.container}>
                 <Spinner
                    visible={this.state.spinner}
                    textContent={'Loading...'}
                    textStyle={styles.spinnerTextStyle}
                />
                <MyStatusBar />
                <ScrollView>
                    <View style={{ flex: 3 }}>
                        <View style={{ flex: 1, margin: 20, top: 20 }}>
                            <Text style={{ fontFamily: 'Gotham-Black', color: '#CFB368', fontSize: 20, textAlign: 'center', margin: 3 }}>{i18n.t('phone')}</Text>
                            <TextInput style={{ height: 40, borderWidth: 1, padding: 5, margin: 10, borderRadius: 10, borderColor: 'grey', fontFamily: 'Gotham-Black', textAlign: 'center', color: 'grey', fontWeight: 'bold', fontSize: 20 }}
                                onChangeText={(destination) => this.setState({ destination })}
                                value={this.state.destination}
                                keyboardType='number-pad'
                                caretHidden={this.state.caretHidden}
                                onFocus={() => this.setState({ caretHidden: false })} />
                            <Text style={{ fontFamily: 'Gotham-Black', color: '#CFB368', fontSize: 20, textAlign: 'center', margin: 3 }}>{i18n.t('amount')}</Text>
                            <TextInput style={{ height: 40, borderWidth: 1, padding: 5, margin: 10, borderRadius: 10, borderColor: 'grey', fontFamily: 'Gotham-Black', textAlign: 'center', color: 'grey', fontWeight: 'bold', fontSize: 20 }}
                                onChangeText={(amount) => this.setState({ amount })}
                                value={this.state.amount}
                                keyboardType='number-pad'
                                caretHidden={this.state.caretHidden}
                                onFocus={() => this.setState({ caretHidden: false })} />
                            <Text style={{ fontFamily: 'Gotham-Black', color: '#CFB368', fontSize: 20, textAlign: 'center', margin: 3 }}>{i18n.t('currentbalance')}</Text>
                            <TextInput style={{ height: 40, borderWidth: 1, padding: 5, margin: 10, borderRadius: 10, borderColor: 'grey', fontFamily: 'Gotham-Black', textAlign: 'center', color: 'grey', fontWeight: 'bold', fontSize: 20 }}
                                editable={false}
                                caretHidden={this.state.caretHidden}
                                onFocus={() => this.setState({ caretHidden: false })}>
                                {this.state.balance}
                            </TextInput>
                            <Text style={{ fontFamily: 'Gotham-Black', color: '#CFB368', fontSize: 20, textAlign: 'center', margin: 3 }}>{i18n.t('password')}</Text>
                            <TextInput style={{ height: 40, borderWidth: 1, padding: 5, margin: 10, borderRadius: 10, borderColor: 'grey', fontFamily: 'Gotham-Black', textAlign: 'center', color: 'grey', fontWeight: 'bold', fontSize: 20 }}
                                onChangeText={(password) => this.setState({ password })}
                                editable={true}
                                caretHidden={this.state.caretHidden}
                                secureTextEntry={true}
                                onFocus={() => this.setState({ caretHidden: false })}>
                            </TextInput>
                            <Text style={{ fontFamily: 'Gotham-Black', color: '#CFB368', fontSize: 20, textAlign: 'center', margin: 3 }}>{i18n.t('message')}</Text>
                            <TextInput style={{ height: 100, borderWidth: 1, padding: 5, margin: 10, borderRadius: 10, borderColor: 'grey', fontFamily: 'Gotham-Black', textAlign: 'center', color: 'grey', fontWeight: 'bold', fontSize: 20 }}
                                onChangeText={(reference) => this.setState({ reference })}
                                value={this.state.reference}
                                caretHidden={this.state.caretHidden}
                                onFocus={() => this.setState({ caretHidden: false })}>
                            </TextInput>
                        </View>
                    </View>
                    <View style={{ flex: 2 }}>
                        <View style={{ flex: 1 }}>
                            <View style={{ flex: 1, flexDirection: 'row', top: 10, margin: 5, marginBottom: 20, marginLeft: 20, marginRight: 20 }}>
                                <View style={{ flex: 1, margin: 5 }}>
                                    <TouchableOpacity style={{ height: 40, borderRadius: 10, backgroundColor: '#CFB368', marginRight: 40, marginLeft: 40, justifyContent: 'center' }} onPress={() => this.handleSend()}>
                                            <Text style={{ fontFamily: 'Gotham-Black', color: 'white', fontSize: 19, textAlign: 'center', margin: 20 }}>{i18n.t('save')}</Text>
                                    </TouchableOpacity>
                                </View>
                            </View>
                        </View>
                    </View>
                </ScrollView>
            </View>
        )
    }
}

const styles = StyleSheet.create({

    container: {
        flex: 1,
        backgroundColor: '#ffff'
    },

    header: {
        flex: 0.5,
        margin: 5,
    },

    content: {
        flex: 3,
        margin: 5,
    },

    field_search: {
        flexDirection: 'row'
    },

    cont_google_map: {
        flex: 1,
        borderWidth: 1,
        margin: 5,
    },

    name_addrees_input: {
        flex: 1,
        margin: 5,
    },

    field_name_addrees: {
        flexDirection: 'row'
    },

    field_detail_addrees: {
        flexDirection: 'row'
    },

    button: {
        height: 40,
        margin: 10,

    },
    curent_balance: {
        flexDirection: 'row',
        margin: 10,
    },
})

const mapStateToProps = (state) => {
    return {
        session_id: state.session_id,
        set_card: state.set_card,
        language: state.language,
        BASE_URL: state.BASE_URL
    }
}

const mapDispatchToProps = (dispacth) => {
    return {
        setCardactive: (cardProps) => dispacth({
            type: ActionType.SET_CARD,
            data: {
                set_card: cardProps.set_card,
            }
        }),
    }
}

export default connect(mapStateToProps, mapDispatchToProps)(TransferBalance);



{/* <View style={styles.content}>
                    <View style={styles.name_addrees_input}>
                        <View style={styles.field_name_addrees}>
                            <View style={{ flex: 1 }}>
                                
                                <TextInput style={{ height: 40, borderWidth: 1, padding: 5, margin: 10 }}
                                    onChangeText={(destination) => this.setState({ destination })}
                                    value={this.state.destination}
                                    keyboardType='number-pad' />
                            </View>
                        </View>
                        <View style={styles.field_detail_addrees}>
                            <View style={{ flex: 1 }}>
                                <TextInput style={{ height: 40, borderWidth: 1, padding: 5, margin: 10 }}
                                    onChangeText={(amount) => this.setState({ amount })}
                                    value={this.state.amount}
                                    keyboardType='number-pad'/>
                            </View>
                        </View>
                        <View style={styles.curent_balance}>
                            <View style={{ flex: 1, margin: 10 }}>
                                <Text style={{ fontSize: 20 }} >Current Balance </Text>
                            </View>
                            <View style={{ flex: 1, margin: 10 }}>
                                <Text style={{ fontSize: 20 }}>{this.state.balance}</Text>
                            </View>
                        </View>
                        <View style={styles.field_detail_addrees}>
                            <View style={{ width: 55, justifyContent: 'center' }}>
                                <Text>Reference</Text>
                            </View>
                            <View style={{ flex: 1 }}>
                                <TextInput style={{ height: 100, borderWidth: 1, padding: 5, margin: 10 }}
                                    onChangeText={(reference) => this.setState({ reference })}
                                    value={this.state.reference} />
                            </View>
                        </View>
                        {/* <View style={{ justifyContent: 'center', margin: 5 }}>
                            <Button title="Activate" onPress={() => this.handle()}></Button>
                        </View> */}
                //         <View style={{ justifyContent: 'center' }} >
                //             <Button title="SEND" onPress={() => this.handleSend()}></Button>
                //         </View>
                //     </View>
                // </View> */}