import React, { Component } from 'react';
import { StyleSheet, Text, View, Button, StatusBar, TouchableOpacity, Image } from 'react-native';
import { connect } from 'react-redux';
import ActionType from '../redux/globalActionType';
import i18n from 'i18n-js';
import CheckBox from 'react-native-check-box'
import { FontAwesome, AntDesign, Feather } from '@expo/vector-icons';
import MyStatusBar from './MyStatusBar';

class Language extends React.Component {
    constructor(props) {
        super(props);
        this.state = {
            language: 'id'
        }
    }

    _changLanguage() {

        let languageProps = {
            language: 'en'
        }
        this.props.setLanguage(languageProps);
        i18n.locale = 'en'
    }

    _changLanguageId() {

        let languageProps = {
            language: 'id'
        }
        this.props.setLanguage(languageProps);
        i18n.locale = 'id'
    }


    render() {
        console.log(this.props.language)
        return (
            <View style={styles.container}>
                <MyStatusBar />
                <View style={{ flex: 0.2 }} />
                <View style={styles.body}>


                    {
                        this.props.language == 'en' ? (
                            <>
                                <TouchableOpacity style={{ flex: 0.2, flexDirection: 'row', backgroundColor: '#CFB368', margin: 10, marginHorizontal: 50, justifyContent: 'center', alignItems: 'center', borderRadius: 10, paddingVertical: 10, paddingHorizontal: 20 }}
                                    onPress={() => this._changLanguage()}>
                                    <View style={{ flex: 0.3, }}>
                                        <Image style={{ height: 26, width: 40 }} source={require('../assets/images/english-flag.png')} />
                                    </View>
                                    <View style={{ flex: 0.4, alignItems: 'center' }}>
                                        <Text style={{ fontSize: 12, fontFamily: 'Gotham-Black', color: 'white' }}>ENGLISH</Text>
                                    </View>
                                    <View style={{ flex: 0.2, alignItems: 'flex-end' }}>
                                        <CheckBox
                                            onClick={() => this._changLanguage()}
                                            isChecked={true}
                                            checkedImage={<AntDesign name='checkcircleo' size={30} color={'#fff'} />}
                                            unCheckedImage={<Feather name='circle' size={30} color={'#fff'} />}
                                        />
                                    </View>
                                </TouchableOpacity>

                                <TouchableOpacity style={{ flex: 0.2, flexDirection: 'row', backgroundColor: 'white', margin: 10, marginHorizontal: 50, justifyContent: 'center', alignItems: 'center', borderRadius: 10, borderWidth:1, borderColor:'gray', paddingVertical: 10, paddingHorizontal: 20 }}
                                    onPress={() => this._changLanguageId()}>
                                    <View style={{ flex: 0.3, }}>
                                        <Image style={{ height: 26, width: 40,borderWidth:1, borderColor:'gray' }} source={require('../assets/images/indonesia-flag.png')} />
                                    </View>
                                    <View style={{ flex: 0.4, alignItems: 'center' }}>
                                        <Text style={{ fontSize: 12, fontFamily: 'Gotham-Black', color: 'gray' }}>INDONESIAN</Text>
                                    </View>
                                    <View style={{ flex: 0.2, alignItems: 'flex-end' }}>
                                        <CheckBox
                                            onClick={() => this._changLanguageId()}
                                            isChecked={false}
                                            checkedImage={<AntDesign name='checkcircleo' size={30} color={'gray'} />}
                                            unCheckedImage={<Feather name='circle' size={30} color={'gray'} />}
                                        />
                                    </View>
                                </TouchableOpacity>
                            </>
                        ) : (
                                <>
                                    <TouchableOpacity style={{ flex: 0.2, flexDirection: 'row', backgroundColor: 'white', margin: 10, marginHorizontal: 50, justifyContent: 'center', alignItems: 'center', borderRadius: 10, borderWidth:1, borderColor:'gray', paddingVertical: 10, paddingHorizontal: 20 }}
                                        onPress={() => this._changLanguage()}>
                                        <View style={{ flex: 0.3, }}>
                                            <Image style={{ height: 26, width: 40 }} source={require('../assets/images/english-flag.png')} />
                                        </View>
                                        <View style={{ flex: 0.4, alignItems: 'center' }}>
                                            <Text style={{ fontSize: 12, fontFamily: 'Gotham-Black', color: 'gray' }}>ENGLISH</Text>
                                        </View>
                                        <View style={{ flex: 0.2, alignItems: 'flex-end' }}>
                                            <CheckBox
                                                onClick={() => this._changLanguage()}
                                                isChecked={false}
                                                checkedImage={<AntDesign name='checkcircleo' size={30} color={'gray'} />}
                                                unCheckedImage={<Feather name='circle' size={30} color={'gray'} />}
                                            />
                                        </View>
                                    </TouchableOpacity>

                                    <TouchableOpacity style={{ flex: 0.2, flexDirection: 'row', backgroundColor: '#CFB368', margin: 10, marginHorizontal: 50, justifyContent: 'center', alignItems: 'center', borderRadius: 10, paddingVertical: 10, paddingHorizontal: 20 }}
                                        onPress={() => this._changLanguageId()}>
                                        <View style={{ flex: 0.3, }}>
                                            <Image style={{ height: 26, width: 40 }} source={require('../assets/images/indonesia-flag.png')} />
                                        </View>
                                        <View style={{ flex: 0.4, alignItems: 'center' }}>
                                            <Text style={{ fontSize: 12, fontFamily: 'Gotham-Black', color: 'white' }}>INDONESIAN</Text>
                                        </View>
                                        <View style={{ flex: 0.2, alignItems: 'flex-end' }}>
                                            <CheckBox
                                                onClick={() => this._changLanguageId()}
                                                isChecked={true}
                                                checkedImage={<AntDesign name='checkcircleo' size={30} color={'#fff'} />}
                                                unCheckedImage={<Feather name='circle' size={30} color={'#fff'} />}
                                            />
                                        </View>
                                    </TouchableOpacity>
                                </>
                            )
                    }



                    <TouchableOpacity onPress={() => this.props.navigation.goBack()}>
                        <View style={styles.button}>
                            <Text style={{ color: 'white', fontSize: 12, fontFamily: 'Gotham-Black' }}>Save</Text>
                        </View>
                    </TouchableOpacity>
                </View>
            </View>

        )
    }
}



const styles = StyleSheet.create({
    container: {
        flex: 1,
        backgroundColor:'white'
    },
    header: {
        flex: 0.2,
        alignItems: 'center',
        justifyContent: 'center'
    },
    body: {
        flex: 0.8,
        flexDirection: 'column'
    },
    titleText: {
        fontSize: 26,
        fontWeight: 'bold',
    },
    languageBorder: {
        flex: 1,
        flexDirection: 'row',
        alignItems: 'center',
        borderWidth: 1,
    },
    languageSpace: {
        marginLeft: 20
    },
    button: {
        flex: 0.2,
        backgroundColor: '#CFB368',
        marginTop: 20,
        marginHorizontal: 80,
        borderRadius: 15,
        padding: 20,
        alignItems: 'center',
        justifyContent: 'center'
    },
    icon: {
        height: 60,
        width: 60
    },


});


const mapStateToProps = (state) => {
    return {
        language: state.language,
    }
}


const mapDispatchToProps = (dispacth) => {
    return {

        setLanguage: (languageProps) => dispacth({
            type: ActionType.SET_CHANGE_LANGUAGE,
            data: {
                language: languageProps.language
            }
        })
    }
}

export default connect(mapStateToProps, mapDispatchToProps)(Language);