import React from 'react';
import { View, Text, Image, StyleSheet, ScrollView, Alert, TouchableOpacity, ActivityIndicator } from 'react-native';
import { Card } from 'react-native-shadow-cards'
import { connect } from 'react-redux';
import Axios from 'axios';
import moment from 'moment'

class RewardsList extends React.Component {
    constructor(props) {
        super(props)
        this.state = {
            rewardsList: [],
            indicator: true
        }
    }

    componentDidMount() {
        this.getRewardsList()
        this._unsubscribe = this.props.navigation.addListener('focus', () => {
            this.setState({
                indicator: true
            })
            this.getRewardsList()

        });
    }

    componentWillUnmount() {
        this._unsubscribe()
    }

    getRewardsList() {
        let params = {
            session_id: this.props.session_id
        }
        Axios.post('https://excelsocrm.ravintoladev.com/crm/v2/reward/get_list', params).then(res => {
            let data = res.data.rewards
            // console.log(data)
            data.map((item, key) => {
                // console.log(item.expire_time)
                item.expire_time = moment(item.expire_time).format("DD MMMM YYYY")
            })
            // console.log(data)
            this.setState({
                rewardsList: data,
                indicator: false
            })

        }).catch(error => {
            let response = error.response.data;
            Alert.alert(response.status, response.msg);
        })
    }

    render() {
        return (
            <View style={styles.container}>
                <View style={styles.header}>
                    <Text style={{ color: 'white', textAlign: 'center', fontSize: 20, fontFamily: 'Gotham-Black' }}>REWARDS E-VOUCHER</Text>
                </View>
                <ScrollView style={styles.body}>
                    {
                        this.state.indicator ? (<ActivityIndicator style={{ top: 20, justifyContent: "center" }} size="large" color="#c9af6d" />) : (
                            this.state.rewardsList.length ? (
                                this.state.rewardsList.map((item, key) => (
                                    <TouchableOpacity key={key} onPress={() => this.props.navigation.navigate('Reward Detail', { rewardId: item.id })}>
                                        <View style={{ alignItems: 'center' }}>
                                            <Card style={{ padding: 5, margin: 5 }}>
                                                <View>
                                                    <Image source={{ uri: item.reward.title_image }}
                                                        resizeMethod="resize"
                                                        resizeMode='cover'
                                                        style={{ height: 100, width: '100%' }} />
                                                </View>
                                                <View style={{ flex: 1, flexDirection: 'row', justifyContent: 'space-between', padding: 10 }}>
                                                    <View style={{ flex: 0.6 }}>
                                                        <Text style={{ textAlign: 'left', fontSize: 12, fontFamily: 'Gotham-Black', color: '#838383' }}>{item.reward.title}</Text>
                                                        <Text style={{ textAlign: 'left', fontSize: 12, fontFamily: 'Gotham-Light', color: '#838383' }}>{item.reward.subtitle}</Text>
                                                    </View>
                                                    <View style={{ flex: 0.4 }}>
                                                        <Text style={{ textAlign: 'right', fontSize: 12, fontFamily: 'Gotham-Light', color: '#838383' }}>Expired On</Text>
                                                        <Text style={{ textAlign: 'right', fontSize: 12, fontFamily: 'Gotham-Light', color: '#838383' }}>{item.expire_time}</Text>
                                                    </View>
                                                </View>
                                            </Card>
                                        </View>
                                    </TouchableOpacity>
                                ))
                            ) : (
                                    <View style={{ justifyContent: 'center', alignItems: 'center', height: 100 }}>
                                        <Text style={{ textAlign: 'left', fontSize: 12, fontFamily: 'Gotham-Light', color: 'grey' }}>No E-Voucher Available</Text>
                                    </View>
                                ))
                    }
                    <TouchableOpacity style={{ marginVertical: 20 }} onPress={() => this.props.navigation.navigate('Reward History')}>
                        <Text style={{ textAlign: 'center', color: '#CFB368', fontSize: 12, fontFamily: 'Gotham-Black' }}>REDEEM E-VOUCHER HISTORY</Text>
                    </TouchableOpacity>
                    <View style={{ height: 15 }} />
                </ScrollView>
            </View>
        )
    }
}

const styles = StyleSheet.create({
    container: {
        flex: 1,
        backgroundColor: 'white',
    },
    header: {
        flex: 0.1,
        marginBottom: 5,
        backgroundColor: '#CFB368',
        justifyContent: 'center'
    },

    body: {
        flex: 3,
    },
    list_detail_order: {
        flex: 1,
        margin: 20,
        borderWidth: 1,
    }
})

const mapStateToProps = (state) => {
    return {

        session_id: state.session_id,

    }
}

export default connect(mapStateToProps)(RewardsList);