import React, { PureComponent } from 'react';
import { View, Text, button, StyleSheet, Button, Alert, TextInput, TouchableOpacity, Image } from 'react-native';
import { connect } from 'react-redux';
import Axios from 'axios';
import ActionType from '../redux/globalActionType';
import i18n from 'i18n-js';
import { StackActions } from '@react-navigation/native';
import { ScrollView, TouchableHighlight } from 'react-native-gesture-handler';
import MyStatusBar from './MyStatusBar';


class ProfilePage extends PureComponent {
    constructor(props) {
        super(props)
        this.state = {
            full_name: '',
            dob_day: '',
            dob_month: '',
            dob_year: '',
            gender: '',
            email: '',
            mobile_phone: '',
            onClicked: false,
        }
    }

    componentDidMount() {
        this.getProfile();
    }


    getProfile() {
        let params = {
            session_id: this.props.session_id
        }

        Axios.post('https://excelsocrm.ravintoladev.com/crm/v2/member/get_profile', params).then(res => {
            let data = res.data
            console.log("INI DATANYA : " + JSON.stringify(data));

            this.setState({
                full_name: data.name,
                email: data.email,
                dob_day: data.dob_day,
                dob_month: data.dob_month,
                dob_year: data.dob_year,
                gender: data.gender_display,
                mobile_phone: data.mobile_phone

            })
        }).catch(error => {
            let response = error.response.data;
            Alert.alert(response.msg);
        })
    }


    onChangeProfil = data => {
        // console.log('DATA FROM CHANGE PROFILE  ' + data);
        this.getProfile()
    }

    handleChangeProfil() {
        this.setState({
            onClicked: true
        })
        this.props.navigation.navigate('Change Profil', { 'data': 'sample', onChangeProfil: this.onChangeProfil })
    }

    // logout() {
    //     const navigation = this.props.navigation
    //     let sessionProps = {
    //         session_id: ''
    //     }
    //     this.props.setSessionid(sessionProps);
    //     navigation.dispatch(StackActions.replace('Login'))
    // }

    logout() {
        const navigation = this.props.navigation
        let sessionProps = {
            session_id: ''
        }
        this.props.setSessionid(sessionProps);
        navigation.reset({
            index: 0,
            routes: [
                {
                    name: 'Login',
                    params: { someParam: 'Param1' },
                },
            ],
        })
    }

    render() {
        return (
            <View style={styles.container}>
                <MyStatusBar />
                <ScrollView>
                    <View style={{ flex: 1, height: 90, top: 10 }}>
                        <View style={{ alignSelf: 'center' }}>
                            <Image
                                style={{ height: 70, width: 70, top: 5, justifyContent: 'center' }}
                                source={require('../assets/images/people-actv.png')}
                            />
                        </View>

                        <Text style={{ fontFamily: 'Gotham-Black', color: 'grey', fontSize: 20, textAlign: 'center', margin: 15 }}>
                            {this.state.full_name}
                        </Text>
                    </View>
                    <View style={{ flex: 3 }}>
                        <View style={{ flex: 1, margin: 20, top: 10 }}>
                            <View style={{ top: 20 }}>
                                <Text style={{ fontFamily: 'Gotham-Black', color: '#CFB368', fontSize: 18, textAlign: 'center', margin: 3 }}>{i18n.t('email')}</Text>
                                <Text style={{ fontFamily: 'Gotham-Black', color: '#838383', fontSize: 14, textAlign: 'center' }}>{this.state.email}</Text>
                            </View>

                            <View style={{ top: 30 }}>
                                <Text style={{ fontFamily: 'Gotham-Black', color: '#CFB368', fontSize: 18, textAlign: 'center', margin: 3 }}>{i18n.t('phone')}</Text>
                                <Text style={{ fontFamily: 'Gotham-Black', color: '#838383', fontSize: 14, textAlign: 'center' }}> {this.state.mobile_phone}</Text>
                            </View>

                            <View style={{ top: 40 }}>
                                <Text style={{ fontFamily: 'Gotham-Black', color: '#CFB368', fontSize: 18, textAlign: 'center', margin: 3 }}>{i18n.t('dob')}</Text>
                                <Text style={{ fontFamily: 'Gotham-Black', color: '#838383', fontSize: 14, textAlign: 'center' }}>{this.state.dob_day} / {this.state.dob_month} / {this.state.dob_year}</Text>
                            </View>

                            <View style={{ top: 50, marginBottom: 50 }}>
                                <Text style={{ fontFamily: 'Gotham-Black', color: '#CFB368', fontSize: 18, textAlign: 'center', margin: 3 }}>{i18n.t('gender')}</Text>
                                {
                                    this.state.gender == 'Wanita' ? (<Text style={{ fontFamily: 'Gotham-Black', color: '#838383', fontSize: 14, textAlign: 'center' }}>{i18n.t('female')}</Text>) : (<Text style={{ fontFamily: 'Gotham-Black', color: '#838383', fontSize: 14, textAlign: 'center' }}>{i18n.t('male')}</Text>)
                                }
                            </View>

                        </View>
                    </View>
                    <View style={{ flex: 2 }}>
                        <View style={{ flex: 1 }}>
                            <View style={{ top: 10, margin: 5, marginRight: 20, marginLeft: 20 }}>
                                <View style={{ flex: 1, margin: 5 }}>
                                    <TouchableOpacity title="Edit" onPress={() => this.props.navigation.navigate('Change password')}>
                                        <View style={{ height: 40, borderRadius: 10, backgroundColor: '#CFB368', justifyContent: 'center' }}>
                                            <Text style={{ fontFamily: 'Gotham-Black', color: 'white', fontSize: 16, textAlign: 'center' }}>{i18n.t('changepassword')}</Text>
                                        </View>
                                    </TouchableOpacity>
                                </View>
                            </View>
                            <View style={{ flex: 1, margin: 5, marginRight: 20, marginLeft: 20 }}>
                                <View style={{ flex: 1, margin: 5 }}>
                                    <TouchableOpacity title="Edit" onPress={() => this.props.navigation.navigate('Change language')}>
                                        <View style={{ height: 40, borderRadius: 10, backgroundColor: '#CFB368', justifyContent: 'center' }}>
                                            <Text style={{ fontFamily: 'Gotham-Black', color: 'white', fontSize: 16, textAlign: 'center' }}>{i18n.t('language')}</Text>
                                        </View>
                                    </TouchableOpacity>
                                </View>
                                <View style={{ flex: 1, margin: 5 }}>
                                    <TouchableOpacity title="Edit" onPress={() => this.logout()}>
                                        <View style={{ height: 40, borderRadius: 10, backgroundColor: '#CFB368', justifyContent: 'center' }}>
                                            <Text style={{ fontFamily: 'Gotham-Black', color: 'white', fontSize: 16, textAlign: 'center' }}>{i18n.t('logout')}</Text>
                                        </View>
                                    </TouchableOpacity>
                                </View>
                            </View>
                        </View>
                    </View>
                </ScrollView>
            </View>
        )
    }
}

const styles = StyleSheet.create({
    container: {
        flex: 1,
        backgroundColor: 'white',

    }
})

const mapDispatchToProps = (dispacth) => {
    return {
        setSessionid: (sessionProps) => dispacth({
            type: ActionType.SET_LOGOUT,
            data: {
                session_id: sessionProps.session_id
            }
        }),
    }
}

const mapStateToProps = (state) => {
    // console.log('PROFIL PAGE' + JSON.stringify(state))
    return {
        session_id: state.session_id,
        language: state.language,
        full_name: state.full_name,
        gender_display: state.gender_display,
    }
}

export default connect(mapStateToProps, mapDispatchToProps)(ProfilePage);

{/* <View style={{ margin: 10, flex: 1, }}>
<View style={{ height: 50 }}>
    <Text style={{ fontSize: 20, margin: 5, flex: 2 }}>Name : </Text>
    <Text style={{ fontSize: 20, margin: 5, flex: 2 }}>{this.state.full_name} </Text>
</View>
<View style={{ height: 50, flexDirection: 'row' }}>
    <Text style={{ fontSize: 20, margin: 5, flex: 2 }}>Date of Birth </Text>
    <Text style={{ fontSize: 20, margin: 5, flex: 2 }}>{this.state.dob_day} / {this.state.dob_month} / {this.state.dob_year} </Text>
</View>
<View style={{ height: 50, flexDirection: 'row' }}>
    <Text style={{ fontSize: 20, margin: 5, flex: 2 }}>Gender :</Text>
    <Text style={{ fontSize: 20, margin: 5, flex: 2 }}>{this.state.gender} </Text>
</View>
<View style={{ height: 50, flexDirection: 'row' }}>
    <Text style={{ fontSize: 20, margin: 5, flex: 2 }}>Email :</Text>
    <Text style={{ fontSize: 20, margin: 5, flex: 2 }}>{this.state.email} </Text>
</View>
</View>
<View style={{ flexDirection: 'row', top: 20, margin: 5, }}>
<View style={{ flex: 1, margin: 5 }}>
    <Button title="Edit" onPress={() => this.handleChangeProfil()}></Button>
</View>
<View style={{ flex: 1, margin: 5 }}>
    <Button title="Change Password" onPress={() => this.props.navigation.navigate('Change password')}></Button>
</View>
</View>
<View style={{ flex: 1, flexDirection: 'row', top: 20, margin: 5 }}>
<View style={{ flex: 1, margin: 5 }}>
    <Button title="Language" onPress={() => this.props.navigation.navigate('Change language')}></Button>
</View>
<View style={{ flex: 1, margin: 5 }}>
    <Button title="Logout" onPress={() => this.logout()}></Button>
</View>
</View> */}
