import * as React from 'react';
import Auth from './view/Auth';
import { NavigationContainer } from '@react-navigation/native';
import { persistStore, persistReducer } from 'redux-persist';
import { AsyncStorage } from 'react-native';
import { PersistGate } from "redux-persist/integration/react";
import rootReducer from './redux/globalReducer';
import { createStore } from 'redux';
import { Provider } from 'react-redux';
import * as Localization from 'expo-localization';
import i18n from 'i18n-js';
import en from './lib/en';
import id from './lib/id';

export const lang = i18n.translations = {
        en:en,
        id:id
    }

  export const set_lang  =  i18n.locale = Localization.locale;
  export const fallbacks = i18n.fallbacks =  true;


const persistConfig = {
  key: 'root',
  storage: AsyncStorage,
};

const persistReducers = persistReducer(persistConfig, rootReducer)
const store = createStore(persistReducers);
const persistor = persistStore(store)
i18n.locale = Localization.locale;
export default function App() {
  return (
    <Provider store={store}>
      <PersistGate loading={null} persistor={persistor}>
        <NavigationContainer>
          <Auth />
        </NavigationContainer>
      </PersistGate>
    </Provider>
  );
}
