import React from 'react';
import { View, Text, TextInput, StyleSheet, Button, Alert } from 'react-native';
import { connect } from 'react-redux';
import Axios from 'axios';
import ActionType from '../redux/globalActionType';

class ChangeEmail extends React.Component {

    constructor(props) {
        super(props);
        this.state = {
            email: ""
        }
    }

    changeEmail() {

        let paramater = {
            "email": this.state.email,
            "registration_id": this.props.registration_id
        }

        Axios.post('https://excelsocrm.ravintoladev.com/crm/v2/auth/register_change_email', paramater).then(res => {
            // console.log(res);
            let loginProps = {
                email: this.state.email

            }
            let emailConfirmProps = {
                isEmailverif: false
            }
            this.props.setChangeEmail(loginProps)
            this.props.setEmailConfirm(emailConfirmProps)
            Alert.alert(
                '',
                'Email terkirim, mohon dicek'
                ,
            )
            this.props.navigation.navigate("Email Confirmation");
        }).catch(error => {

            let response = error.response.data;
            Alert.alert(response.msg);
        })
    }

    render() {
        return (
            <View style={styles.container}>
                <View style={styles.header}>
                    <Text style={{ textAlign: 'center', marginTop: 10, fontSize: 25 }}>Change Email</Text>
                </View>
                <View style={styles.form}>
                    <View style={styles.field_email}>
                        <View style={{ width: 55, justifyContent: 'center' }}>
                            <Text>Email</Text>
                        </View>
                        <View style={{ flex: 1 }}>
                            <TextInput style={{ height: 40, borderWidth: 1, padding: 5, margin: 10 }}
                                onChangeText={(email) => this.setState({ email })}
                                value={this.state.email}
                            />

                        </View>
                    </View>
                    <View style={styles.button}>
                        <Button title="Submit" onPress={() => this.changeEmail()}></Button>
                    </View>
                </View>
            </View>
        )
    }
}

const styles = StyleSheet.create({

    container: {
        flex: 1,
        backgroundColor: '#ffff'
    },

    header: {
        flex: 0.5,
        margin: 10,
    },

    form: {
        flex: 3,
        margin: 10,
        marginTop: 0,
    },

    field_email: {
        flexDirection: 'row'
    },

    button: {
        height: 50,
        margin: 10,

    }

})


const mapDispatchToProps = (dispacth) => {
    return {
        setChangeEmail: (params) => dispacth({
            type: ActionType.SET_CHANGE_EMAIL,
            data: {
                email: params.email,
            }
        }),

        setEmailConfirm:(emailConfirmProps) => dispacth({
            type: ActionType.SET_EMAIL_VERIFICATION,
            data:{
                isEmailverif: emailConfirmProps.isEmailverif,
            }
        })
    }
}
const mapStateToProps = (state) => {
    return {
        registration_id: state.registration_id
    }
}

export default connect(mapStateToProps, mapDispatchToProps)(ChangeEmail);