import React, { Component } from 'react';
import { StyleSheet, Text, View, Button, StatusBar, TouchableOpacity, Image } from 'react-native';
import { connect } from 'react-redux';
import ActionType from '../redux/globalActionType';
import i18n from 'i18n-js';

class Language extends React.Component {
    constructor(props) {
        super(props);
        this.state = {
            language: 'id'
        }
    }

    _changLanguage() {

        let languageProps = {
            language: 'en'
        }
        this.props.setLanguage(languageProps);
        i18n.locale = 'en'
    }

    _changLanguageId() {

        let languageProps = {
            language: 'id'
        }
        this.props.setLanguage(languageProps);
        i18n.locale = 'id'
    }


    render() {

        return (
            <View style={styles.container}>
                <View style={styles.header}>
                    <StatusBar barStyle='dark-content' />
                    <Text style={styles.titleText}> {i18n.t('welcome')}</Text>
                </View>
                <View style={styles.body}>
                    <TouchableOpacity onPress={() => this._changLanguage()}>
                        <View style={styles.languageBorder}>
                            <View style={styles.languageSpace}>
                                {/* <Image style={styles.icon} source={require('../assets/English-Language-icon.png')}></Image> */}
                            </View>
                            <View style={styles.languageSpace}>
                                <Text>ENG</Text>
                            </View>
                        </View>
                    </TouchableOpacity>
                    <TouchableOpacity onPress={() => this._changLanguageId()}>
                        <View style={styles.languageBorder}>
                            <View style={styles.languageSpace}>
                                {/* <Image style={styles.icon} source={require('../assets/Indonesia-Flag-icon.png')}></Image> */}
                            </View>
                            <View style={styles.languageSpace}>
                                <Text>ID</Text>
                            </View>
                        </View>
                    </TouchableOpacity>
                  
                    <View style={styles.button}>
                        <Button title="save" onPress={()=>this.props.navigation.goBack()}/>
                    </View>
                </View>
            </View>
        )
    }
}



const styles = StyleSheet.create({
    container: {
        flex: 1,
        borderWidth: 1
    },
    header: {
        flex: 0.2,
        alignItems: 'center',
        justifyContent: 'center'
    },
    body: {
        flex: 0.6,
        flexDirection: 'column',
        borderWidth: 1,
        marginLeft: 60,
        marginRight: 60,
    },
    titleText: {
        fontSize: 26,
        fontWeight: 'bold',
    },
    languageBorder: {
        flexDirection: 'row',
        alignItems: 'center',
        borderWidth: 1,
        marginTop: 50,
        marginRight: 40,
        marginLeft: 40
    },
    languageSpace: {
        marginLeft: 20
    },
    button: {
        marginTop: 50,
        marginLeft: 60,
        marginRight: 60
    },
    icon: {
        height: 60,
        width: 60
    },


});


const mapStateToProps = (state) => {
    return {
        language: state.language,
    }
}


const mapDispatchToProps = (dispacth) => {
    return {

        setLanguage: (languageProps) => dispacth({
            type: ActionType.SET_CHANGE_LANGUAGE,
            data: {
                language: languageProps.language
            }
        })
    }
}

export default connect(mapStateToProps, mapDispatchToProps)(Language);