import React, { PureComponent } from 'react';
import { View, Text, button, StyleSheet, Button, TextInput, Picker, Alert } from 'react-native';
import { connect } from 'react-redux';
import Axios from 'axios';
import RNPickerSelect from 'react-native-picker-select';
import { BASE_URL_GET_ENUM } from '../model/Base_Model';
import ActionType from '../redux/globalActionType';

class ChangeProfil extends React.Component {
    constructor(props) {
        super(props)
        this.state = {
            full_name: '',
            dob_day: '',
            dob_month: '',
            dob_year: '',
            gender: [],
            gender_selected: '',
            email: '',
            no_tlp: '',
        }
        // console.log('PROPS : ' + JSON.stringify(props.navigation))
    }

    componentDidMount() {

        Axios.get(BASE_URL_GET_ENUM).then(res => {
            // console.log('ENUM :' + JSON.stringify(res.data.gender));
            let gender = res.data.gender;
            let gender_list = []


            for (const gen in gender) {
                if (gender.hasOwnProperty(gen)) {
                    const label = gender[gen];
                    const value = gen;
                    gender_list.push({ label: label, value: value })
                }
            }

            this.setState({
                gender: gender_list,

            })
            // console.log('STATE GENDER' + JSON.stringify(this.state.gender))
            // this.state.gender.map()
        })

        let params = {
            session_id: this.props.session_id
        }

        Axios.post('https://excelsocrm.ravintoladev.com/crm/v1/member/get_profile', params).then(res => {
            let data = res.data
            this.setState({
                full_name: data.name,
                email: data.email,
                dob_day: data.dob_day,
                dob_month: data.dob_month,
                dob_year: data.dob_year,
                gender_selected: data.gender.toString()
            })


            // console.log('AFTER CALL : ' + JSON.stringify(this.state.gender_selected))
        })


    }

    saveData() {

        let params1 = {
            session_id: this.props.session_id,
            name: this.state.full_name,
            gender: this.state.gender_selected,
            mobile_phone: this.state.no_tlp
        }
        Axios.post('https://excelsocrm.ravintoladev.com/crm/v2/member/set_profile', params1).then(res => {
            this.props.navigation.goBack()
            this.props.route.params.onChangeProfil({ example: 'wakwaw' })
            // console.log(JSON.stringify('A : ' + JSON.stringify(this.props.route.params)))
        })

    }

    render() {
        return (
            <View style={styles.container}>
                <Text style={{ textAlign: "center", margin: 50, fontWeight: 'bold', fontSize: 25 }}> Change Profile </Text>
                <View style={{ margin: 10, flex: 1, }}>
                    <View style={{ height: 50, flexDirection: 'row' }}>
                        <Text style={{ fontSize: 20, margin: 5, flex: 1 }}>Name </Text>
                        <TextInput
                            style={{ height: 40, borderColor: 'gray', borderWidth: 1, padding: 5, flex: 2 }}
                            onChangeText={(full_name) => this.setState({ full_name })}
                            value={this.state.full_name}
                        />
                    </View>
                    <View style={{ height: 50, flexDirection: 'row' }}>
                        <Text style={{ fontSize: 20, margin: 5, flex: 1 }}>Date of {'\n'}Birth </Text>
                        <Text style={{ fontSize: 15, margin: 5, borderWidth: 1, flex: 2, padding: 5 }}>{this.state.dob_day} - {this.state.dob_month} - {this.state.dob_year} </Text>
                    </View>
                    <View style={{ height: 50, flexDirection: 'row' }}>
                        <View style={{ flex: 1 }}>
                            <Text style={{ fontSize: 20, margin: 5, flex: 1 }}>Gender </Text>
                        </View>
                        <View style={{ height: 50, flex: 1 }}>
                            <RNPickerSelect
                                value={this.state.gender_selected}
                                // itemKey="1"
                                placeholderTextColor='gray'
                                onValueChange={(value) => this.setState({ gender_selected: value })}
                                items={this.state.gender} />
                        </View>
                    </View>
                    <View style={{ height: 50, flexDirection: 'row' }}>
                        <Text style={{ fontSize: 20, margin: 5, flex: 1 }}>Email </Text>
                        <TextInput
                            style={{ height: 40, borderColor: 'gray', borderWidth: 1, padding: 5, flex: 2 }}
                            onChangeText={(full_name) => this.setState({ full_name })}
                            value={this.state.email}
                        />
                    </View>
                    <View style={{ height: 50, flexDirection: 'row' }}>
                        <Text style={{ fontSize: 20, margin: 5, flex: 1 }}>Mobile phone </Text>
                        <TextInput
                            style={{ height: 40, borderColor: 'gray', borderWidth: 1, padding: 5, flex: 2, margin: 10 }}
                            onChangeText={(no_tlp) => this.setState({ no_tlp })}
                            value={this.state.no_tlp}
                        />
                    </View>
                    <View style={{ flexDirection: 'row', top: 0, margin: 10, }}>
                        <View style={{ flex: 1, margin: 5 }}>
                            <Button title="Save" onPress={() => this.saveData()}></Button>
                        </View>
                        <View style={{ flex: 1, margin: 5 }}>
                            <Button title="Cancel"></Button>
                        </View>
                    </View>
                </View>

            </View>
        )
    }
}


const styles = StyleSheet.create({
    container: {
        flex: 1,
        backgroundColor: 'white',

    }
})


const mapDispatchToProps = (dispacth) => {
    return {
        setChangeProfilProps: (changeProfilProps) => dispacth({
            type: ActionType.SET_CHANGE_PROFIL,
            data: {
                full_name: changeProfilProps.full_name,
                gender_display: changeProfilProps.gender_display,
            }
        }),
    }
}
const mapStateToProps = (state) => {
    return {

        session_id: state.session_id,
        gender_display: state.gender_display,
        full_name: state.full_name

    }
}

export default connect(mapStateToProps, mapDispatchToProps)(ChangeProfil);