import React from 'react';
import { View, Text, StyleSheet, ScrollView, TouchableOpacity, Image, TextInput } from 'react-native';
import { connect } from 'react-redux';
import ActionType from '../redux/globalActionType';


class Item extends React.Component {

    constructor(props) {
        super(props)
        this.state = {
            value: 0
        }
    }
    handleChangeQuantity = (item, qty) => {

        if (qty == '') {
            item.qty=0
        } else {
          
            const order_item = {
                id: item.id,
                code: item.code,
                name: item.name,
                description: item.description,
                note: 'jangan garing',
                image: item.image,
                price: parseInt(item.price),
            }

            this.props.changeQuantity({ item: order_item, quantity: qty })
            console.log("ini udah masuk sini");
        }
    }

    render() {
        const { item } = this.props
        // console.log("ini id itemnya "+item.id)
        return (
            <View style={{ flex: 1, margin: 10 }} key={item.id} ref={this.props._scrollView}>
                <ScrollView ref={view => this._scrollView = view}>
                    {item.code == 'CATEGORY' ? (
                        <Text style={{ fontSize: 20, color: '#c9af6d' }}>{item.name}</Text>
                    ) : (

                            <View style={{ flexDirection: 'row' }}>
                                <View >
                                    <Image source={{ uri: item.image }} style={{ height: 100, width: 100, borderRadius: 5, top: 5 }}></Image>
                                </View>
                                <View >
                                    <Text style={{ fontSize: 20, margin: 5, marginRight: 10, fontWeight: 'bold' }}>{item.name}</Text>
                                    <Text style={{ fontSize: 15, margin: 5, marginRight: 10 }}>Rp. {item.price}</Text>
                                    <View style={{ flexDirection: 'row', flex: 1 }}>
                                        <View style={styles.shadowEdit}></View>
                                        <View style={styles.shadowAdd}>
                                            <TouchableOpacity onPress={() => this.props.handleMin()}>
                                                <Text style={{ fontSize: 20, margin: 2 }}> - </Text>
                                            </TouchableOpacity>
                                            <TextInput
                                                style={{ height: 25, padding: 2, textAlign: 'center', margin: 2 }}
                                                keyboardType={'numeric'}
                                                onChangeText={(qty) => this.handleChangeQuantity(item, qty)}>{item.qty}</TextInput>
                                            <TouchableOpacity onPress={() => this.props.handleAdd()}>
                                                <Text style={{ fontSize: 20, margin: 2 }}> + </Text>
                                            </TouchableOpacity>
                                        </View>
                                    </View>
                                </View>
                            </View>
                        )}
                </ScrollView>
            </View>
        )
    }
}

const styles = StyleSheet.create({
    shadowEdit: {
        height: 30,
        width: 25,
        borderWidth: 1,
        borderRadius: 2,
        borderColor: '#ddd',
        borderBottomWidth: 0,
        shadowColor: '#000',
        shadowOffset: { width: 0, height: 2 },
        shadowOpacity: 0.8,
        shadowRadius: 2,
        elevation: 1,
        marginLeft: 5,
        marginRight: 5,
        marginTop: 10,
    },
    shadowAdd: {
        height: 30,
        width: 75,
        borderWidth: 1,
        borderRadius: 2,
        borderColor: '#ddd',
        borderBottomWidth: 0,
        shadowColor: '#000',
        shadowOffset: { width: 0, height: 2 },
        shadowOpacity: 0.8,
        shadowRadius: 2,
        elevation: 1,
        marginLeft: 5,
        marginRight: 5,
        marginTop: 10,
        flexDirection: 'row'
    },
    shadowMin: {
        height: 20,
        width: 20,
        borderWidth: 1,
        borderRadius: 2,
        borderColor: '#ddd',
        borderBottomWidth: 0,
        shadowColor: '#000',
        shadowOffset: { width: 0, height: 2 },
        shadowOpacity: 0.8,
        shadowRadius: 2,
        elevation: 1,
        marginLeft: 5,
        marginRight: 5,
        marginTop: 10,
    }
})

const mapDispatchToProps = (dispacth) => {
    return {
        setChangeQuantity: (item) => dispacth({
            type: ActionType.CHANGE_TO_CHART,
            data: {
                item: item
            }
        }),
        changeQuantity: (params) => dispacth({
            type: ActionType.CHANGE_QUANTITY,
            data: {
                item: params.item,
                new_quantity: params.quantity
            }
        }),
    }
}
const mapStateToProps = (state) => {
    // console.log(state)
    return {
        session_id: state.session_id,
        outlet_id: state.outlet_id,
        order_quantity: state.order_quantity,
        order_total: state.order_total,
        quantity: state.quantity,
    }
}

export default connect(mapStateToProps, mapDispatchToProps)(Item)
