import React from 'react';
import { View, Text, TextInput, StyleSheet, Button, Image } from 'react-native';
import Axios from 'axios';

export default function MenuDetail({ route, navigation }) {
    const { desc } = route.params;
    const { nama } = route.params;
    const { Foto } = route.params;
    return (
        <View style={styles.container}>
            <View style={styles.header}>
                <Text style={{ textAlign: 'center', margin: 20, fontSize: 25, alignSelf: 'center' }}>{nama}</Text>
            </View>
            <View style={styles.body}>
                {/* <View style={styles.images}> */}
                <Image style={{ height: '50%', width: '100%' }}
                    source={{
                        uri: Foto
                    }}
                />
                {/* </View> */}
                <View style={styles.content}>
                    <Text style={{ margin: 20, textAlign: 'justify' }}>
                        {desc}
                    </Text>
                </View>
            </View>
        </View>
    )
}

const styles = StyleSheet.create({

    container: {
        flex: 1,
        backgroundColor: 'white',
    },
    header: {

        flex: 0.5,
    },
    images: {
        margin: 10,
        flex: 2,

        justifyContent: 'center',
    },
    content: {
        flex: 2,
    },
    body: {
        flex: 3,
    },

})




