import React from 'react';
import { View, Text, TextInput, StyleSheet, ScrollView, Alert, TouchableOpacity, ActivityIndicator } from 'react-native';
import { Card } from 'react-native-shadow-cards'
import { connect } from 'react-redux';
import Axios from 'axios';
import session from '../function/session';

class OrderHistory extends React.Component {

    constructor(props) {
        super(props)
        this.state = {
            order_list: [],
            indicator: true
        }
    }


    componentDidMount() {
        this.getOrderHistory()
        this._unsubscribe = this.props.navigation.addListener('focus', () => {

            this.setState({
                indicator: true,
            })
            this.getOrderHistory()


        });
    }

    componentWillUnmount() {
        this._unsubscribe();
    }
    // componentDidMount() {
    //     this.getOrderHistory()
    // }

    getOrderHistory() {
        let params = {
            session_id: this.props.session_id
        }
        Axios.post('https://excelsocrm.ravintoladev.com/crm/v2/transaction/list', params).then(res => {
            let data = res.data.data
            // console.log(data)
            this.setState({
                order_list: data,
                indicator: false,
            })
        }).catch(error => {
            const { navigation } = this.props
            let response = error.response.data
            session(response, navigation)
            Alert.alert(response.msg);
            this.setState({
                indicator: false,
            })
        })
    }

    render() {
        // console.log(this.state.order_list)
        return (
            <View style={styles.container}>
                <ScrollView style={styles.body}>

                    {this.state.indicator == true ? (<ActivityIndicator style={{ justifyContent: "center" }} size="large" color="#c9af6d" />) :
                        this.state.order_list.map((item, key) => (
                            <TouchableOpacity key={key} onPress={() => this.props.navigation.navigate('Order Detail', { idTrans: item.id })}>
                                <View key={key}>
                                    <Card style={{ padding: 10, margin: 10, alignContent: 'center' }}>
                                        <Text>OUTLET : {item.outlet}</Text>
                                        <Text>TGL TRANSAKSI : {item.trans_date}</Text>
                                        <Text>TOTAL : {item.trans_total}</Text>
                                        <Text>STATUS : {item.trans_status_display}</Text>
                                    </Card>
                                </View>
                            </TouchableOpacity>
                        ))
                    }
                </ScrollView>
            </View>
        )
    }
}

const styles = StyleSheet.create({
    container: {
        flex: 1,
        backgroundColor: 'white',
    },
    header: {

        flex: 0.2,
    },

    body: {
        flex: 3,
        margin: 5,
    },
    list_detail_order: {
        flex: 1,
        margin: 20,
        borderWidth: 1,
    }
})

const mapStateToProps = (state) => {
    return {

        session_id: state.session_id,

    }
}

export default connect(mapStateToProps)(OrderHistory);