import React, { useState, useEffect } from 'react';
import { View, Text, StyleSheet, Button, FlatList, TextInput, Dimensions } from 'react-native';
import { connect } from 'react-redux';
import MapView, { PROVIDER_GOOGLE } from 'react-native-maps';
import Axios from 'axios';

import { Card } from 'react-native-shadow-cards';
class OutletDetail extends React.Component {
    constructor(props) {
        super(props)
        this.state = {
            data: [],
            latitude: 0,
            longitude: 0,
            name_outlets: '',
            name_address: ''


        }
    }
    componentDidMount() {
        this.getMaps()
    }

    getMaps() {
        const { navigation, route } = this.props;
        const { id } = route.params
        // console.log(this.props.session_id)

        let params = {
            session_id: this.props.session_id,
            outlet_id: id
        }
        // console.log("INI PARAMETERNYA" + JSON.stringify(params))

        Axios.post("https://excelsocrm.ravintoladev.com/crm/v2/outlet/get_detail", params).then(res => {
            let data_details = res.data.outlet
            let lat = data_details.lat
            let long = data_details.long
            let name_outlets = data_details.name
            let name_address = data_details.address

            this.setState({
                latitude: lat,
                longitude: long,
                name_outlets: name_outlets,
                name_address: name_address
            })

        }).catch(error => {
            let response = error.response.data;
            Alert.alert(response.msg);
            this.setState({
                spinner: false,
            })
        })
    }

    render() {
        return (
            <View style={styles.container}>
                <View style={{ flex: 2 }}>
                    <MapView style={{ flex: 1 }}
                        region={{
                            latitude: this.state.latitude,
                            longitude: this.state.longitude,
                            latitudeDelta: 0.1,
                            longitudeDelta: 0.1,

                        }}
                        zoomEnabled={true}
                        loadingEnabled={true}
                        provider={PROVIDER_GOOGLE}
                    >

                    </MapView>
                </View>
                <View style={{ flex: 2 }}>
                    <Text style={{ textAlign: 'center', fontSize: 20, margin: 5 }}>{this.state.name_outlets}</Text>
                    <Text style={{ textAlign: 'center', fontSize: 12, margin: 5 }}>{this.state.name_address}</Text>
                </View>
            </View>
        )
    }
}


const styles = StyleSheet.create({
    container: {
        flex: 1,
        backgroundColor: 'white',
    },
    header: {

        flex: 0.5,
    },

    body: {
        flex: 5,
        margin: 20,
    },
    list_addrees: {
        flex: 2,
        margin: 5,
    },

    searchbar: {
        flex: 1,
        justifyContent: 'center',
        margin: 10,
    },
})

const mapStateToProps = (state) => {
    return {

        session_id: state.session_id,
        outlet_id: state.outlet_id,
        name_outlet: state.name_outlet,
    }
}

export default connect(mapStateToProps)(OutletDetail);


