import React from 'react';
import { View, Text, TextInput, StyleSheet, Button, Image } from 'react-native';
import Axios from 'axios';

export default function MenuDetail({ route, navigation }) {
    const { desc } = route.params;
    const { nameMenu } = route.params;
    const { image } = route.params;
    return (
        <View style={styles.container}>
            <View style={styles.body}>
                <Image style={{ height: '50%', width: '100%' }}
                    source={{
                        uri: image
                    }}
                />
                <View style={{height:50,justifyContent:'center'}}>
                    <Text style={{fontFamily:'Gotham-Black',fontSize:25,textAlign:'center',color:'grey'}}>{nameMenu}</Text>
                </View>
                <View style={{height:1,backgroundColor:'grey',marginRight:15,marginLeft:15,borderWidth:1,borderColor:'grey'}}></View>
                <View style={styles.content}>
                    <Text style={{ fontSize:15, fontFamily:'Gotham-Light',textAlign:'center',marginTop:10 }}>
                        {desc}
                    </Text>
                </View>
            </View>
        </View>
    )
}

const styles = StyleSheet.create({

    container: {
        flex: 1,
        backgroundColor: 'white',
    },
    images: {
        margin: 10,
        flex: 2,

        justifyContent: 'center',
    },
    content: {
        flex: 2,
    },
    body: {
        flex: 3,
    },

})




