import React from 'react';
import { View, Text, TextInput, StyleSheet, Button, Alert, TouchableOpacity, Image } from 'react-native';
import { connect } from 'react-redux';
import Axios from 'axios';
import { BASE_URL_NEW_PASSWORD } from '../model/Base_Model'
import Spinner from 'react-native-loading-spinner-overlay';

class NewPassword extends React.Component {
    constructor(props) {
        super(props)
        this.state = {
            confirmation_number: '',
            email: this.props.email,
            password: this.props.password,
            password_confirmation: '',
            spinner: false,
        }
    }

    componentDidMount() {
        // console.log(this.props)
    }

    validation() {
        this.setState({
            spinner: true,
        })
        if (this.state.password !== this.state.password_confirmation) {
            this.setState({
                spinner: false,
            })
            Alert.alert(
                '',
                'Password harus sama!'
                ,
            )

        } else {
            this.handleResetPassword();
        }
    }

    handleResetPassword() {
        this.setState({
            spinner: true,
        })
        let params = {
            'confirmation_number': this.state.confirmation_number,
            'email': this.state.email,
            'password': this.state.password,
            'password_confirmation': this.state.password_confirmation
        }
        // console.log(params);
        Axios.post(BASE_URL_NEW_PASSWORD, params).then(res => {
            this.setState({
                spinner: false,
            })
            this.props.navigation.navigate('Login')
        }).catch(error => {
            this.setState({
                spinner: false,
            })
            let response = error.response.data;
            Alert.alert(response.msg);
        })
    }

    render() {
        return (
            <View style={styles.container}>
                <Spinner
                    visible={this.state.spinner}
                    textContent={'Loading...'}
                    textStyle={styles.spinnerTextStyle}
                />
                <View style={{ flex: 3 }}>
                    <View style={{ flex: 1, marginRight: 30, marginLeft: 30, top: 50 }}>
                        <Text style={{ fontFamily: 'Gotham-Black', color: '#CFB368', fontSize: 20, textAlign: 'center', margin: 3 }}>Email</Text>
                        <Text style={{ fontFamily: 'Gotham-Black', color: '#838383', fontSize: 20, textAlign: 'center', margin: 3, marginBottom: 15 }}>{this.props.email}</Text>



                        <Text style={{ fontFamily: 'Gotham-Black', color: '#CFB368', fontSize: 20, textAlign: 'center', margin: 3 }}>Token</Text>
                        <TextInput style={{ height: 40, borderWidth: 1, padding: 5, margin: 10, borderRadius: 10, borderColor: 'grey', fontFamily: 'Gotham-Black', textAlign: 'center', color: 'grey', fontWeight: 'bold', fontSize: 20 }}
                            onChangeText={(confirmation_number) => this.setState({ confirmation_number })}
                            value={this.state.confirmation_number} />
                        <Text style={{ fontFamily: 'Gotham-Black', color: '#CFB368', fontSize: 20, textAlign: 'center', margin: 3 }}>New Password</Text>
                        <TextInput style={{ height: 40, borderWidth: 1, padding: 5, margin: 10, borderRadius: 10, borderColor: 'grey', fontFamily: 'Gotham-Black', textAlign: 'center', color: 'grey', fontWeight: 'bold', fontSize: 20 }}
                            onChangeText={(password) => this.setState({ password })}
                            value={this.state.password}
                            secureTextEntry={true} />
                        <Text style={{ fontFamily: 'Gotham-Black', color: '#CFB368', fontSize: 20, textAlign: 'center', margin: 3 }}>Repeat Password</Text>
                        <TextInput style={{ height: 40, borderWidth: 1, padding: 5, margin: 10, borderRadius: 10, borderColor: 'grey', fontFamily: 'Gotham-Black', textAlign: 'center', color: 'grey', fontWeight: 'bold', fontSize: 20 }}
                            onChangeText={(password_confirmation) => this.setState({ password_confirmation })}
                            value={this.state.password_confirmation}
                            secureTextEntry={true} />
                        <TouchableOpacity style={{ height: 100 }} onPress={() => this.handleResetPassword()}>
                            <View style={{ backgroundColor: '#CFB368', height: 45, top: 20, borderRadius: 10, marginRight: 50, marginLeft: 50 }}>
                                <Text style={{ alignSelf: 'center', top: 10, color: 'white', fontFamily: 'Gotham-Black', fontSize: 20 }}>SUBMIT</Text>
                            </View>
                        </TouchableOpacity>
                    </View>
                </View>
                <View style={{ flex: 1, flexDirection: 'row' }}>
                    <View style={styles.v_logo}>
                        <View style={{ flex: 1, alignSelf: 'flex-start' }}>
                            <Image resizeMode="contain" source={require('../assets/images/daun.png')} style={styles.logo}></Image>
                        </View>
                        <View style={{ flex: 1 }}>
                        </View>
                    </View>

                    <View style={{ flex: 0.5 }}>

                    </View>
                </View>
            </View>
        )
    }
}

const styles = StyleSheet.create({

    container: {
        flex: 1,
        backgroundColor: '#ffff'
    },

    form: {
        flex: 3,
        margin: 10,
        marginTop: 0,
    },


    v_logo: {
        flex: 2,
        flexDirection: 'column-reverse',
        alignContent: 'flex-start',
    },
    logo: {
        alignSelf: 'flex-start',
        marginTop: 50,
        width: 290,
        height: 290,
        bottom: 150,

    },

})

const mapStateToProps = (state) => {
    console.log(JSON.stringify(state))
    return {
        email: state.email
    }
}

export default connect(mapStateToProps)(NewPassword);



{/* <Spinner
                    visible={this.state.spinner}
                    textContent={'Loading...'}
                    textStyle={styles.spinnerTextStyle}
                />
                <View style={styles.header}>
                    <Text style={{ textAlign: 'center', marginTop: 10, fontSize: 25 }}>New Password</Text>
                </View>
                <View style={styles.form}>
                    <View style={styles.field_token}>
                        <View style={{ width: 55, justifyContent: 'center' }}>
                            <Text>Token</Text>
                        </View>
                        <View style={{ flex: 1 }}>
                            <TextInput style={{ height: 40, borderWidth: 1, padding: 5, margin: 10 }}
                                onChangeText={(confirmation_number) => this.setState({ confirmation_number })}
                                value={this.state.confirmation_number} />
                        </View>
                    </View>
                    <View style={styles.field_new_password}>
                        <View style={{ width: 55, justifyContent: 'center' }}>
                            <Text>New Password</Text>
                        </View>
                        <View style={{ flex: 1 }}>
                            <TextInput style={{ height: 40, borderWidth: 1, padding: 5, margin: 10 }}
                                onChangeText={(password) => this.setState({ password })}
                                value={this.state.password}  
                                secureTextEntry={true}/>
                        </View>
                    </View>
                    <View style={styles.field_repeat_password}>
                        <View style={{ width: 55, justifyContent: 'center' }}>
                            <Text>Repeat Password</Text>
                        </View>
                        <View style={{ flex: 1 }}>
                            <TextInput style={{ height: 40, borderWidth: 1, padding: 5, margin: 10 }}
                                onChangeText={(password_confirmation) => this.setState({ password_confirmation })}
                                value={this.state.password_confirmation} 
                                secureTextEntry={true}/>
                        </View>
                    </View>
                    <View style={styles.button}>
                        <Button title="Submit" onPress={() => this.validation()}></Button>
                    </View>
                </View> */}