import Axios from 'axios';
import moment from 'moment';
import React from 'react';
import { Alert, ScrollView, StyleSheet, Text, TextInput, TouchableOpacity, View } from 'react-native';
import { AirbnbRating } from 'react-native-elements';
import Spinner from 'react-native-loading-spinner-overlay';
import { connect } from 'react-redux';
import MyStatusBar from './MyStatusBar';
import i18n from 'i18n-js';


class RatingOrder extends React.Component {

    constructor(props) {
        super(props);
        this.state = {
            review: "",
            rating: 5,
            outlet: '',
            outlet_code: '',
            trans_status_display: '',
            transaction_detail: [],
            numberId: '',
            detail_trans: '',
            trans_status: '',
            modalVisible: false,
            spinner: false,
            caretHidden: true,
        }
    }

    componentDidMount() {
        this.getDetailTrans();
    }


    getDetailTrans() {
        let params = {
            session_id: this.props.session_id,
            transaction_id: this.props.route.params.idTrans
        }
        // console.log("PARAMETER : " + JSON.stringify(params))
        Axios.post(this.props.BASE_URL + 'crm/v2/transaction/detail', params).then(res => {
            let data = res.data
            // console.log('ini data' + JSON.stringify(data))
            // console.log("INI OUTLET "+ data.outlet)
            // console.log("OUTLET-CODE" + data.outlet_code)
            // console.log("TRANS-DISPLAY" + data.trans_type_display)

            this.setState({
                outlet: data.outlet,
                outlet_code: data.outlet_code,
                trans_status_display: data.trans_status_display,
                transaction_detail: data.transaction_detail,
                detail_trans: data,
                trans_status: data.trans_status,
                numberId: data.id.substring(0, 5).toUpperCase()

            })
        }).catch(error => {
            const { navigation } = this.props
            let response = error.response.data
            session(response, navigation)
            Alert.alert(response.msg);
            this.setState({
                indicator: false,
            })
            // let response = error.response.data;
            // Alert.alert(response.msg);
        })
    }

    rating(rating) {

        this.setState({
            rating: rating,

        })
    }

    review() {
        let parameter = {
            session_id: this.props.session_id,
            transaction_id: this.props.route.params.idTrans,
            rating: this.state.rating,
            review: this.state.review,
            lat: this.props.lat,
            long: this.props.long
        }
        if (parameter.rating < 4 && parameter.review == "") {
            Alert.alert('', i18n.t('reviewMustFill'));
        } else {
            this.setState({ spinner: true })
            Axios.post(this.props.BASE_URL + 'crm/v2/review/transaction', parameter).then(res => {
                Alert.alert('', i18n.t('thanksForReview'))
                this.setState({ spinner: false })
                this.props.navigation.navigate('Home');

            }).catch(error => {
                this.setState({ spinner: false })
                let response = error.response.data;
                Alert.alert(response.msg);
            })
        }
    }

    render() {
        return (
            <ScrollView style={styles.container}>
                <MyStatusBar />
                <Spinner
                    visible={this.state.spinner}
                    textContent={'Loading...'}
                    textStyle={styles.spinnerTextStyle}
                />
                <View style={{ flex: 3 }}>
                    <View style={{ height: 100, justifyContent: 'center' }}>
                        <Text style={{ margin: 20, fontFamily: 'Gotham-Light', fontSize: 14, color: '#838383' }}>{i18n.t('reviewText')} <Text style={{ color: 'red' }}>{this.state.detail_trans.trans_type_display}</Text> {i18n.t('reviewText2')}  {this.state.outlet}  {i18n.t('reviewText3')}  <Text style={{ fontSize: 12, fontFamily: 'Gotham-Light', textAlign: 'center', color: '#838383' }}>{moment(this.state.detail_trans.trans_time).format('DD MMMM YYYY HH:mm:ss')}</Text> </Text>
                    </View>
                    <View style={{ flex: 1, marginRight: 30, marginLeft: 30, }}>
                        <AirbnbRating
                            count={5}
                            reviews={["Needs improvement", "Below average", "Average", "Good", "Awesome"]}
                            onFinishRating={rating => this.rating(rating)}
                            defaultRating={5}
                            size={30}
                        />
                        <Text style={{ fontFamily: 'Gotham-Black', color: '#CFB368', fontSize: 20, textAlign: 'center', margin: 3, top: 10 }}>Review</Text>
                        <TextInput style={{ height: 150, borderWidth: 1, padding: 10, margin: 10, borderRadius: 10, borderColor: 'grey', fontFamily: 'Gotham-Black', textAlign: 'center', color: 'grey', fontWeight: 'bold', fontSize: 20, top: 20 }}
                            onChangeText={(review) => this.setState({ review })}
                            value={this.state.review}
                            autoCapitalize="none"
                            value={this.state.review}
                            multiline={true}
                            numberOfLines={4}
                            blurOnSubmit={false}
                            caretHidden={this.state.caretHidden}
                            onFocus={() => this.setState({ caretHidden: false })}
                        />

                        <TouchableOpacity style={{ height: 100 }} onPress={() => this.review()}>
                            <View style={{ backgroundColor: '#CFB368', height: 40, top: 20, borderRadius: 10, marginRight: 50, marginLeft: 50 }}>
                                <Text style={{ alignSelf: 'center', top: 10, color: 'white', fontFamily: 'Gotham-Black', fontSize: 20 }}>{i18n.t('submit')}</Text>
                            </View>
                        </TouchableOpacity>
                    </View>
                </View>
                <View style={{ flex: 1, flexDirection: 'row' }}>
                    <View style={{ flex: 0.5 }}>
                    </View>
                </View>
            </ScrollView>
        )
    }
}

const styles = StyleSheet.create({

    container: {
        flex: 1,
        backgroundColor: '#ffff'
    },

    header: {
        flex: 0.5,
        margin: 10,
    },

    form: {
        flex: 3,
        top: 40,
        margin: 10,
        marginTop: 0,
    },

    field_email: {
        flexDirection: 'row'
    },

    button: {
        height: 40,
        margin: 10,

    },
    logo: {
        alignSelf: 'flex-start',
        marginTop: 50,
        width: 290,
        height: 290,
        bottom: 145,

    },
    v_logo: {
        flex: 2,
        flexDirection: 'column-reverse',
        alignContent: 'flex-start',
    }

})



const mapStateToProps = (state) => {
    return {

        session_id: state.session_id,
        lat: state.lat,
        long: state.long,
        BASE_URL: state.BASE_URL,
    }
}

export default connect(mapStateToProps)(RatingOrder);


