import * as React from 'react';
import { createStackNavigator, HeaderBackButton } from '@react-navigation/stack';
import { connect } from 'react-redux';
import { View, Text, Image, Alert } from 'react-native';
import ActionType from '../redux/globalActionType';
import MenuSelection from './MenuSelection';
import { Ionicons, MaterialCommunityIcons } from '@expo/vector-icons';
import Home from './Home';
import Login from './Login';
import Register from './Register';
import ResetPassword from './ResetPassword';
import VerifyEmail from './VerifyEmail';
import NewPassword from './NewPassword';
import ChangeEmail from './ChangeEmail';
import CardActivation from './CardActivation';
import ConfirmMobile from './ConfirmMobile';
import Balance from './Balance';
import RedeemCode from './RedeemCode';
import TransactionHistory from './TransactionHistory'
import TransactionDetail from './TransactionDetail'
import EmailConfirmation from './EmailConfirmation';
import Renewal from './Renewal';
import NewsDetail from './NewsDetail';
import DeliveryAddress from './DeliveryAddrees';
import PickupName from './PickupName';
import MenuConfirmation from './MenuConfirmation';
import AddressDetail from './AddreesDetail';
import ShoppingCart from './ShoppingCart';
import TransferBalance from './TransferBalance';
import CardInfo from './CardInfo';
import ChangeLanguage from './ChangeLanguage';
import ChangePassword from './ChangePassword';
import DateTime from './Date';
import NewRegister from './New_Register';
import ProfilePage from './ProfilePage';
import ChangeProfile from './ChangeProfil';
import i18n from 'i18n-js';
import TopUpInfo from './TopUpInfo';
import UpgradePremium from './UpgradePremium';
import Account from './Account';
import Cameras from './Camera';
import OutletDetail from './OutletDetails';
import { createBottomTabNavigator } from '@react-navigation/bottom-tabs';
import { enableScreens } from 'react-native-screens';
import MenuDetail from './MenuDetail';
import OrderHistory from './OrderHistory';
import OrderDetail from './OrderDetail';
import RewardsList from './RewardsList';
import RewardDetail from './RewardDetail';
import RewardSelect from './RewardSelect';
import Outlets from './Outlets';
import RewardHistory from './RewardHistory';
import WelcomeReg from './WelcomeReg';
import WelcomeLog from './WelcomeLog';
import RatingOrder from './RatingOrder';
import UseBalance from './UseBalance';
import PaymentCode from './PaymentCode';

enableScreens();


const Tab = createBottomTabNavigator();

function HomePage({ navigation }) {
  return (
    <Tab.Navigator

      // screenOptions={({ route }) => ({
      //   tabBarIcon: ({ focused, color, size }) => {
      //     let iconName;

      //     if (route.name === 'HOME') {
      //       iconName = focused ? 'ios-home' : 'ios-home'
      //     } else if (route.name === 'MENU') {
      //       iconName = focused ? 'ios-paper' : 'ios-paper';
      //     } else if (route.name === 'REWARDS') {
      //       iconName = focused ? 'ios-gift' : 'ios-gift';
      //     } else if (route.name === 'ORDER') {
      //       iconName = focused ? 'md-cart' : 'md-cart';
      //     } else if (route.name === 'OUTLETS') {
      //       iconName = focused ? 'ios-cafe' : 'ios-cafe';
      //     } else if (route.name === 'ACCOUNT') {
      //       iconName = focused ? 'account' : 'account';
      //       return <MaterialCommunityIcons name={iconName} size={size} color={color} />
      //     }

      //     // You can return any component that you like here!
      //     return <Ionicons name={iconName} size={size} color={color} />;
      //   },

      // })}
      screenOptions={({ route }) => ({
        tabBarIcon: ({ focused, color, size }) => {
          let iconName;

          if (route.name === 'HOME') {
            // iconName = focused ? 'ios-home' : 'ios-home'
            return <Image source={require('../assets/icon/icon-home.png')} style={{ height: 50, width: 50 }} tintColor={focused ? '#CFB368' : 'gray'} />
          } else if (route.name === 'MENU') {
            // iconName = focused ? 'ios-paper' : 'ios-paper';
            return <Image source={require('../assets/icon/icon-menu.png')} style={{ height: 50, width: 50 }} tintColor={focused ? '#CFB368' : 'gray'} />
          } else if (route.name === 'REWARDS') {
            // iconName = focused ? 'ios-gift' : 'ios-gift';
            return <Image source={require('../assets/icon/icon-rewards.png')} style={{ height: 50, width: 50 }} tintColor={focused ? '#CFB368' : 'gray'} />
          } else if (route.name === 'ORDER') {
            // iconName = focused ? 'md-cart' : 'md-cart';
            return <Image source={require('../assets/icon/icon-order.png')} style={{ height: 50, width: 50 }} tintColor={focused ? '#CFB368' : 'gray'} />
          } else if (route.name === 'OUTLETS') {
            // iconName = focused ? 'ios-cafe' : 'ios-cafe';
            return <Image source={require('../assets/icon/icon-outlets.png')} style={{ height: 50, width: 50 }} tintColor={focused ? '#CFB368' : 'gray'} />
          } else if (route.name === 'ACCOUNT') {
            // iconName = focused ? 'account' : 'account';
            return <Image source={require('../assets/icon/icon-account.png')} style={{ height: 50, width: 50 }} tintColor={focused ? '#CFB368' : 'gray'} />
          }

          // You can return any component that you like here!
          return <Ionicons name={iconName} size={size} color={color} />;
        },

      })}

      tabBarOptions={{ activeTintColor: '#CFB368', inactiveTintColor: 'gray', showLabel: false }}

    >
      <Tab.Screen name="HOME" component={Home} />
      <Tab.Screen name="MENU" component={MenuSelection} />
      <Tab.Screen name="REWARDS" component={RewardsList} />
      <Tab.Screen name="ORDER" component={OrderHistory} />
      <Tab.Screen name="OUTLETS" component={Outlets} />
      <Tab.Screen name="ACCOUNT" component={Account} />
    </Tab.Navigator>


  );
}
const Stack = createStackNavigator();
class Auth extends React.Component {
  constructor(props) {
    super(props);
    i18n.locale = this.props.language;
  }

  render() {
    return (
      <Stack.Navigator>
        {
          this.props.session_id === '' ? (
            <>

              <Stack.Screen name="Login" component={Login} options={{ headerShown: false }} />
              <Stack.Screen name="Home" component={Home} />
              <Stack.Screen name="Profile" component={ProfilePage} options={{
                headerStyle: { backgroundColor: '#CFB368' },
                headerTitleContainerStyle: { alignContent: 'center' },
                headerTitleAlign: 'center',
                headerTintColor: '#fff',
                headerTitleStyle: {
                  alignSelf: 'center',
                  fontFamily: 'Gotham-Black',
                  color: 'white',
                  textAlign: 'center'
                }, title: 'PROFILE'
              }} />
              <Stack.Screen name="Change Profil" component={ChangeProfile} options={{
                headerStyle: { backgroundColor: '#CFB368' },
                headerTitleContainerStyle: { alignContent: 'center' },
                headerTitleAlign: 'center',
                headerTintColor: '#fff',
                headerTitleStyle: {
                  alignSelf: 'center',
                  fontFamily: 'Gotham-Black',
                  color: 'white',
                  textAlign: 'center'
                }, title: 'CHANGE PROFILE'
              }} />
              <Stack.Screen name="Register" component={Register} />
              {/* <Stack.Screen name="Change language" component={ChangeLanguage} /> */}
              <Stack.Screen name="Email Confirmation" component={EmailConfirmation} options={{
                headerStyle: { backgroundColor: '#CFB368' },
                headerTitleContainerStyle: { alignContent: 'center' },
                headerTitleAlign: 'center',
                headerTintColor: '#fff',
                headerTitleStyle: {
                  alignSelf: 'center',
                  fontFamily: 'Gotham-Black',
                  color: 'white',
                  textAlign: 'center'
                }, title: 'EMAIL CONFIRMATION'
              }} />
              <Stack.Screen name="Welcomes" component={WelcomeReg} options={{
                headerShown: false,
              }} />

            </>
          ) : this.props.pageEmailConfirmation === true ? (
            <>
              <Stack.Screen name="Email Confirmation" component={EmailConfirmation} />
              <Stack.Screen name="Login" component={Login} />
              <Stack.Screen name="LoginWelcome" component={WelcomeLog} options={{
                headerShown: false,
              }} />
              <Stack.Screen name="Home" component={Home} options={{ headerShown: false }} />
            </>
          ) : (
                <>
                  <Stack.Screen name="Login Welcome" component={WelcomeLog} options={{
                    headerShown: false,
                  }} />
                  <Stack.Screen name="Home" component={HomePage}
                    options={{
                      headerShown: false,
                      title: 'TODAY PROMOTION',
                      headerStyle: { backgroundColor: '#CFB368' },
                      headerTitleContainerStyle: { alignContent: 'center' },
                      headerTitleStyle: {
                        alignSelf: 'center',
                        fontFamily: 'Gotham-Black',
                        color: 'white',
                        textAlign: 'center'
                      }
                    }} />

                  <Stack.Screen name="Profile" component={ProfilePage}
                    options={{
                      headerStyle: { backgroundColor: '#CFB368' },
                      headerTitleContainerStyle: { alignContent: 'center' },
                      headerTitleAlign: 'center',
                      headerTintColor: '#fff',
                      headerTitleStyle: {
                        alignSelf: 'center',
                        fontFamily: 'Gotham-Black',
                        color: 'white',
                        textAlign: 'center'
                      }, title: 'PROFILE'
                    }} />
                  <Stack.Screen name="Change Profil" component={ChangeProfile} />
                  <Stack.Screen name="Change language" component={ChangeLanguage}
                    options={{
                      headerStyle: { backgroundColor: '#CFB368' },
                      headerTitleContainerStyle: { alignContent: 'center' },
                      headerTitleAlign: 'center',
                      headerTintColor: '#fff',
                      headerTitleStyle: {
                        alignSelf: 'center',
                        fontFamily: 'Gotham-Black',
                        fontSize: 20,
                        color: 'white',
                        textAlign: 'center'
                      }, title: 'LANGUAGE'
                    }}
                  />
                  <Stack.Screen name="Change password" component={ChangePassword} options={{
                    headerStyle: { backgroundColor: '#CFB368' },
                    headerTitleContainerStyle: { alignContent: 'center' },
                    headerTitleAlign: 'center',
                    headerTintColor: '#fff',
                    headerTitleStyle: {
                      alignSelf: 'center',
                      fontFamily: 'Gotham-Black',
                      color: 'white',
                      textAlign: 'center'
                    }, title: 'CHANGE PASSWORD'
                  }} />
                  <Stack.Screen name="Card Activation" component={CardActivation} options={{
                    headerStyle: { backgroundColor: '#CFB368' },
                    headerTitleContainerStyle: { alignContent: 'center' },
                    headerTitleAlign: 'center',
                    headerTintColor: '#fff',
                    headerTitleStyle: {
                      alignSelf: 'center',
                      fontFamily: 'Gotham-Black',
                      fontSize: 20,
                      color: 'white',
                      textAlign: 'center'
                    }, title: 'ACTIVATE CARD'
                  }} />
                  <Stack.Screen name="Renewal" component={Renewal} options={{
                    headerStyle: { backgroundColor: '#CFB368' },
                    headerTitleContainerStyle: { alignContent: 'center' },
                    headerTitleAlign: 'center',
                    headerTintColor: '#fff',
                    headerTitleStyle: {
                      alignSelf: 'center',
                      fontFamily: 'Gotham-Black',
                      color: 'white',
                      textAlign: 'center'
                    }, title: 'RENEWAL'
                  }} />
                  <Stack.Screen name="Account" component={Account} />
                  <Stack.Screen name="Login" component={Login} options={{ headerShown: false }} />
                  <Stack.Screen name="Transfer Balance" component={TransferBalance} options={{
                    headerStyle: { backgroundColor: "#CFB368" },
                    headerBackTitleStyle: { color: 'white' },
                    headerTintColor: '#fff',
                    headerTitleAlign: 'center',
                    headerTitleStyle: {
                      fontFamily: 'Gotham-Black',
                      color: 'white',
                      fontSize: 20,
                    },
                    title: 'TRANSFER BALANCE'
                  }} />
                  <Stack.Screen name="Register" component={Register} />
                  <Stack.Screen name="Email Confirmation" component={EmailConfirmation} />
                  <Stack.Screen name="Upgrade Premium" component={UpgradePremium}
                    options={{
                      headerStyle: { backgroundColor: '#CFB368' },
                      headerTitleContainerStyle: { alignContent: 'center' },
                      headerTitleAlign: 'center',
                      headerTintColor: '#fff',
                      headerTitleStyle: {
                        alignSelf: 'center',
                        fontFamily: 'Gotham-Black',
                        fontSize: 20,
                        color: 'white',
                        textAlign: 'center'
                      }, title: 'Upgrade Premium'
                    }} />
                  <Stack.Screen name="Camera" component={Cameras} />
                  <Stack.Screen name="Delivery Address" component={DeliveryAddress} options={{
                    headerStyle: { backgroundColor: '#CFB368' },
                    headerTitleContainerStyle: { alignContent: 'center' },
                    headerTitleAlign: 'center',
                    headerTintColor: '#fff',
                    headerTitleStyle: {
                      alignSelf: 'center',
                      fontFamily: 'Gotham-Black',
                      fontSize: 20,
                      color: 'white',
                      textAlign: 'center'
                    }, title: 'DELIVERY ADDRESS'
                  }} />
                  <Stack.Screen name="Address Detail" component={AddressDetail} options={{
                    headerStyle: { backgroundColor: '#CFB368' },
                    headerTitleContainerStyle: { alignContent: 'center' },
                    headerTitleAlign: 'center',
                    headerTintColor: '#fff',
                    headerTitleStyle: {
                      alignSelf: 'center',
                      fontFamily: 'Gotham-Black',
                      fontSize: 20,
                      color: 'white',
                      textAlign: 'center'
                    }, title: 'TAMBAH ALAMAT'
                  }} />
                  <Stack.Screen name="Menu Detail" component={MenuDetail}
                    options={({ route }) => ({
                      headerStyle: { backgroundColor: '#CFB368' },
                      headerTitleContainerStyle: { alignContent: 'center' },
                      headerTitleAlign: 'center',
                      headerTintColor: '#fff',
                      headerTitleStyle: {
                        alignSelf: 'center',
                        fontFamily: 'Gotham-Black',
                        fontSize: 20,
                        color: 'white',
                        textAlign: 'center'
                      }, title: route.params.nameMenu
                    })}
                  />
                  <Stack.Screen name="Pickup Name" component={PickupName} options={{
                    headerStyle: { backgroundColor: '#CFB368' },
                    headerTitleContainerStyle: { alignContent: 'center' },
                    headerTitleAlign: 'center',
                    headerTintColor: '#fff',
                    headerTitleStyle: {
                      alignSelf: 'center',
                      fontFamily: 'Gotham-Black',
                      fontSize: 20,
                      color: 'white',
                      textAlign: 'center'
                    }, title: 'PICKUP STORE'
                  }} />
                  <Stack.Screen name="Outlet Detail" component={OutletDetail} />
                  <Stack.Screen name="Menu Select" component={MenuSelection} options={{ headerShown: false }} />
                  <Stack.Screen name="Card Info" component={CardInfo} />
                  <Stack.Screen name="Shopping Cart" component={ShoppingCart}
                    options={{
                      headerStyle: { backgroundColor: '#CFB368' },
                      headerTitleContainerStyle: { alignContent: 'center' },
                      headerTitleAlign: 'center',
                      headerTintColor: '#fff',
                      headerTitleStyle: {
                        alignSelf: 'center',
                        fontFamily: 'Gotham-Black',
                        fontSize: 20,
                        color: 'white',
                        textAlign: 'center'
                      }, title: 'SHOPPING CART'
                    }} />
                  <Stack.Screen name="Order History" component={OrderHistory} />
                  <Stack.Screen name="Reward History" component={RewardHistory}
                    options={{
                      headerStyle: { backgroundColor: '#CFB368' },
                      headerTitleContainerStyle: { alignContent: 'center' },
                      headerTitleAlign: 'center',
                      headerTintColor: '#fff',
                      headerTitleStyle: {
                        alignSelf: 'center',
                        fontFamily: 'Gotham-Black',
                        fontSize: 20,
                        color: 'white',
                        textAlign: 'center'
                      }, title: 'Reward History'
                    }}
                  />

                  <Stack.Screen name="Order Detail" component={OrderDetail} options={({ navigation, route }) => ({
                    headerStyle: { backgroundColor: '#CFB368' },
                    headerTitleContainerStyle: { alignContent: 'center' },
                    headerTitleAlign: 'center',
                    headerTintColor: '#fff',
                    headerTitleStyle: {
                      alignSelf: 'center',
                      fontFamily: 'Gotham-Black',
                      fontSize: 20,
                      color: 'white',
                      textAlign: 'center'
                    },
                    title: 'ORDER DETAIL',
                    headerLeft: props => <HeaderBackButton  {...props} onPress={() => navigation.navigate('Home', { screen: 'ORDER' })} />,

                  })} />

                  <Stack.Screen name="RatingOrder" component={RatingOrder}
                    options={{
                      headerStyle: { backgroundColor: '#CFB368' },
                      headerTitleContainerStyle: { alignContent: 'center' },
                      headerTitleAlign: 'center',
                      headerTintColor: '#fff',
                      headerTitleStyle: {
                        alignSelf: 'center',
                        fontFamily: 'Gotham-Black',
                        fontSize: 20,
                        color: 'white',
                        textAlign: 'center'
                      }, title: 'RATING ORDER'
                    }}
                  />
                  <Stack.Screen name="UseBalance" component={UseBalance}
                    options={{
                      headerStyle: { backgroundColor: '#CFB368' },
                      headerTitleContainerStyle: { alignContent: 'center' },
                      headerTitleAlign: 'center',
                      headerTintColor: '#fff',
                      headerTitleStyle: {
                        alignSelf: 'center',
                        fontFamily: 'Gotham-Black',
                        fontSize: 20,
                        color: 'white',
                        textAlign: 'center'
                      }, title: 'USE BALANCE'
                    }}
                  />
                  <Stack.Screen name="PaymentCode" component={PaymentCode}
                    options={{
                      headerStyle: { backgroundColor: '#CFB368' },
                      headerTitleContainerStyle: { alignContent: 'center' },
                      headerTitleAlign: 'center',
                      headerTintColor: '#fff',
                      headerTitleStyle: {
                        alignSelf: 'center',
                        fontFamily: 'Gotham-Black',
                        fontSize: 20,
                        color: 'white',
                        textAlign: 'center'
                      }, title: 'PAYMENT CODE',

                    }}
                  />

                </>
              )


        }

        <Stack.Screen name="New Password" component={NewPassword} options={{
          headerStyle: { backgroundColor: "#ccb46c" },
          headerBackTitleStyle: { color: 'white' },
          headerTitleAlign: 'center',
          headerTintColor: '#fff',
          headerTitleStyle: {
            textAlign: 'center',
            fontSize: 20,
            fontFamily: 'Gotham-Black',
            color: 'white'
          },
          headerTitle: 'New Password'

        }} />
        {/* <Stack.Screen name="Login" component={Login} /> */}
        <Stack.Screen name="Reset Password" component={ResetPassword}
          options={{
            headerStyle: { backgroundColor: "#ccb46c" },
            headerBackTitleStyle: { color: 'white' },
            headerTitleAlign: 'center',
            headerTintColor: '#fff',
            headerTitleStyle: {
              textAlign: 'center',
              fontSize: 20,
              fontFamily: 'Gotham-Black',
              color: 'white'
            },
            headerTitle: 'RESET PASSWORD'

          }} />

        <Stack.Screen name="Verify Email" component={VerifyEmail} />
        <Stack.Screen name="Change Email" component={ChangeEmail} options={{
          headerStyle: { backgroundColor: "#ccb46c" },
          headerBackTitleStyle: { color: 'white' },
          headerTitleAlign: 'center',
          headerTintColor: '#fff',
          headerTitleStyle: {
            textAlign: 'center',
            fontSize: 20,
            fontFamily: 'Gotham-Black',
            color: 'white'
          },
          headerTitle: 'CHANGE EMAIL'

        }} />
        {/* <Stack.Screen name="Card Activation" component={CardActivation} /> */}
        <Stack.Screen name="Confirm Mobile" component={ConfirmMobile} />
        <Stack.Screen name="Balance" component={Balance} />
        <Stack.Screen name="Redeem Code" component={RedeemCode}
         options={({ navigation }) => ({
            headerStyle: { backgroundColor: "#CFB368" },
            headerBackTitleStyle: { color: 'white' },
            headerTintColor: '#fff',
            headerTitleAlign: 'center',
            headerTitleStyle: {
              fontFamily: 'Gotham-Black',
              color: 'white',
              fontSize: 20,
            },
            title: 'REDEEM CODE',
            headerLeft: props => <HeaderBackButton  {...props} onPress={() => navigation.navigate('Home', { screen: 'HOME' })} />,
          })} />

        <Stack.Screen name="Transaction History" component={TransactionHistory}
          options={{
            headerStyle: { backgroundColor: "#CFB368" },
            headerBackTitleStyle: { color: 'white' },
            headerTintColor: '#fff',
            headerTitleAlign: 'center',
            headerTitleStyle: {
              fontFamily: 'Gotham-Black',
              color: 'white',
              fontSize: 20,
            },
            title: 'TRANSACTION HISTORY'
          }} />
        <Stack.Screen name="Transaction Detail" component={TransactionDetail}
          options={{
            headerStyle: { backgroundColor: "#CFB368" },
            headerBackTitleStyle: { color: 'white' },
            headerTintColor: '#fff',
            headerTitleAlign: 'center',
            headerTitleStyle: {
              fontFamily: 'Gotham-Black',
              color: 'white',
              fontSize: 20,
            },
            title: 'TRANSACTION DETAIL'
          }} />
        {/* <Stack.Screen name="Email Confirmation" component={EmailConfirmation} /> */}

        <Stack.Screen name="News Detail" component={NewsDetail} options={{ headerShown: false }} />
        <Stack.Screen name="CONFIRM YOUR ORDER" component={MenuConfirmation}
          options={{
            headerStyle: { backgroundColor: "#CFB368" },
            headerBackTitleStyle: { color: 'white' },
            headerTintColor: '#fff',
            headerTitleAlign: 'center',
            headerTitleStyle: {
              fontFamily: 'Gotham-Black',
              color: 'white',
              fontSize: 20,
            },
            title: 'CONFIRM YOUR ORDER'
          }} />
        <Stack.Screen name="Date Time" component={DateTime} />
        <Stack.Screen name="New Register" component={NewRegister}
          options={{
            headerStyle: { backgroundColor: "#ccb46c" },
            headerBackTitleStyle: { color: 'white' },
            headerTintColor: '#fff',
            headerTitleAlign: 'center',
            headerTitleStyle: {
              fontFamily: 'Gotham-Black',
              color: 'white',
              fontSize: 20,
            },
            title: 'REGISTER'
          }} />
        <Stack.Screen name="TopUpInfo" component={TopUpInfo} options={{ headerShown: false }} />
        <Stack.Screen name="Reward Detail" component={RewardDetail}
          options={{
            headerStyle: { backgroundColor: "#CFB368" },
            headerBackTitleStyle: { color: 'white' },
            headerTintColor: '#fff',
            headerTitleAlign: 'center',
            headerTitleStyle: {
              fontFamily: 'Gotham-Black',
              color: 'white',
              fontSize: 20,
            },
            title: 'REWARD DETAIL'
          }} />
        <Stack.Screen name="Reward Select" component={RewardSelect}
          options={{
            headerStyle: { backgroundColor: "#CFB368" },
            headerBackTitleStyle: { color: 'white' },
            headerTintColor: '#fff',
            headerTitleAlign: 'center',
            headerTitleStyle: {
              fontFamily: 'Gotham-Black',
              color: 'white',
              fontSize: 20,
            },
            title: 'REWARD SELECT'
          }} />
      </Stack.Navigator>
    )
  }
}

const mapStateToProps = (state) => {
  return {
    session_id: state.session_id,
    language: state.language,
    pageEmailConfirmation: state.pageEmailConfirmation
  }
}

export default connect(mapStateToProps)(Auth);




