import React from 'react';
import { View, Text, TextInput, StyleSheet, Button, Alert, TouchableOpacity, Image } from 'react-native';
import { Rating, AirbnbRating } from 'react-native-elements';
import { connect } from 'react-redux';
import Axios from 'axios';
import moment from 'moment'
import ActionType from '../redux/globalActionType';
import Spinner from 'react-native-loading-spinner-overlay';

class RatingOrder extends React.Component {

    constructor(props) {
        super(props);
        this.state = {
            review: "",
            rating: 5,
            outlet: '',
            outlet_code: '',
            trans_status_display: '',
            transaction_detail: [],
            numberId: '',
            detail_trans: '',
            trans_status: '',
            modalVisible: false,
        }
    }

    componentDidMount() {
        this.getDetailTrans();
    }


    getDetailTrans() {
        let params = {
            session_id: this.props.session_id,
            transaction_id: this.props.route.params.idTrans
        }
        // console.log("PARAMETER : " + JSON.stringify(params))
        Axios.post('https://excelsocrm.ravintoladev.com/crm/v2/transaction/detail', params).then(res => {
            let data = res.data
            // console.log('ini data' + JSON.stringify(data))
            // console.log("INI OUTLET "+ data.outlet)
            // console.log("OUTLET-CODE" + data.outlet_code)
            // console.log("TRANS-DISPLAY" + data.trans_type_display)

            this.setState({
                outlet: data.outlet,
                outlet_code: data.outlet_code,
                trans_status_display: data.trans_status_display,
                transaction_detail: data.transaction_detail,
                detail_trans: data,
                trans_status: data.trans_status,
                numberId: data.id.substring(0, 5).toUpperCase()

            })
        }).catch(error => {
            const { navigation } = this.props
            let response = error.response.data
            session(response, navigation)
            Alert.alert(response.msg);
            this.setState({
                indicator: false,
            })
            // let response = error.response.data;
            // Alert.alert(response.msg);
        })
    }

    rating(rating) {

        this.setState({
            rating: rating,

        })
    }

    review() {
        let parameter = {
            session_id: this.props.session_id,
            transaction_id: this.props.route.params.idTrans,
            rating: this.state.rating,
            review: this.state.review,
            lat: this.props.lat,
            long: this.props.long
        }
        if (parameter.rating < 4 && parameter.review == "") {
            Alert.alert('', 'Review Wajib Diisi !');
        } else {

            Axios.post('https://excelsocrm.ravintoladev.com/crm/v2/review/transaction', parameter).then(res => {
                Alert.alert('', 'Terimakasih Atas masukan anda!')
                this.props.navigation.navigate('Home');

            }).catch(error => {
                console.log("INI error " + error)
                let response = error.response.data;
                Alert.alert(response.msg);
            })
        }
    }

    render() {
        return (
            <View style={styles.container}>
                <View style={{ flex: 3 }}>
                    <View style={{ height: 100, justifyContent: 'center' }}>
                        <Text style={{ margin: 20, fontFamily: 'Gotham-Light', fontSize: 14, color: '#838383' }}>How was your experience with your <Text style={{ color: 'red' }}>{this.state.detail_trans.trans_type_display}</Text> order with us  {this.state.outlet}  on  <Text style={{ fontSize: 12, fontFamily: 'Gotham-Light', textAlign: 'center', color: '#838383' }}>{moment(this.state.detail_trans.trans_time).format('DD MMMM YYYY HH:mm:ss')}</Text> </Text>
                    </View>
                    <View style={{ flex: 1, marginRight: 30, marginLeft: 30, }}>
                        <AirbnbRating
                            count={5}
                            reviews={["Needs improvement", "Below average", "Average", "Good", "Awesome"]}
                            onFinishRating={rating => this.rating(rating)}
                            defaultRating={5}
                            size={30}
                        />
                        <Text style={{ fontFamily: 'Gotham-Black', color: '#CFB368', fontSize: 20, textAlign: 'center', margin: 3, top: 10 }}>Review</Text>
                        <TextInput style={{ height: 150, borderWidth: 1, padding: 10, margin: 10, borderRadius: 10, borderColor: 'grey', fontFamily: 'Gotham-Black', textAlign: 'center', color: 'grey', fontWeight: 'bold', fontSize: 20, top: 20 }}
                            onChangeText={(review) => this.setState({ review })}
                            value={this.state.review}
                            autoCapitalize="none"
                            value={this.state.review}
                            multiline={true}
                            numberOfLines={4}
                            blurOnSubmit={false}
                        />

                        <TouchableOpacity style={{ height: 100 }} onPress={() => this.review()}>
                            <View style={{ backgroundColor: '#CFB368', height: 40, top: 20, borderRadius: 10, marginRight: 50, marginLeft: 50 }}>
                                <Text style={{ alignSelf: 'center', top: 10, color: 'white', fontFamily: 'Gotham-Black', fontSize: 20 }}>SUBMIT</Text>
                            </View>
                        </TouchableOpacity>
                    </View>
                </View>
                <View style={{ flex: 1, flexDirection: 'row' }}>
                    <View style={{ flex: 0.5 }}>
                    </View>
                </View>
            </View>
        )
    }
}

const styles = StyleSheet.create({

    container: {
        flex: 1,
        backgroundColor: '#ffff'
    },

    header: {
        flex: 0.5,
        margin: 10,
    },

    form: {
        flex: 3,
        top: 40,
        margin: 10,
        marginTop: 0,
    },

    field_email: {
        flexDirection: 'row'
    },

    button: {
        height: 40,
        margin: 10,

    },
    logo: {
        alignSelf: 'flex-start',
        marginTop: 50,
        width: 290,
        height: 290,
        bottom: 145,

    },
    v_logo: {
        flex: 2,
        flexDirection: 'column-reverse',
        alignContent: 'flex-start',
    }

})



const mapStateToProps = (state) => {
    return {

        session_id: state.session_id,
        lat: state.lat,
        long: state.long,
    }
}

export default connect(mapStateToProps)(RatingOrder);


