import React from 'react';
import { View, Text, TextInput, StyleSheet, Button, TouchableOpacity, Alert, BackHandler, ToastAndroid } from 'react-native';
import { connect } from 'react-redux';
import Axios from 'axios';
import ActionType from '../redux/globalActionType';

class RedeemCode extends React.Component {

    constructor(props) {
        super(props);
        this.handleBackButtonClick = this.handleBackButtonClick.bind(this)
        this.state = {

        }
    }

    componentDidMount() {
        BackHandler.addEventListener('hardwareBackPress', this.handleBackButtonClick);

    }

    componentWillUnmount() {
        BackHandler.removeEventListener('hardwareBackPress', this.handleBackButtonClick);
    }


    handleBackButtonClick() {
        this.props.navigation.navigate('Home', { screen: 'HOME' });
        return true;
    }

    cancel() {
        let params = {
            session_id: this.props.session_id,
        }

        Axios.post('https://excelsocrm.ravintoladev.com/crm/v2/point/refund', params).then(res => {
            console.log(res.data)

            let redeemProps = {
                in_payment: false,
                redeem_code: '',
                balance_redeem: '',
                point_redeem: ''
            }

            this.props.setRedeem(redeemProps)

            // Alert.alert('', 'Berhasil dibatalkan')
            ToastAndroid.show("berhasil dibatalkan", ToastAndroid.SHORT)
            this.props.navigation.navigate('Home', { screen: 'HOME' });
        }).catch(error => {
            let response = error.response.data
            if (response.code === "EMPTY_PIN") {
                Alert.alert('Error', response.msg)
            } else {
                let response = error.response.data;
                Alert.alert('', response.msg);
            }

        })

    }

    render() {
        console.log(this.props)
        return (
            <View style={styles.container}>
                {/* <View style={styles.header}>
                    <Text style={{ textAlign: 'center', fontSize: 25 }}>Payment Code</Text>
                </View> */}
                <View style={{ marginTop: 50 }}>
                    <Text style={{ fontFamily: 'Gotham-Black', color: '#838383', fontSize: 26, textAlign: 'center' }}>{this.props.redeem_code}</Text>
                    <View style={{ borderWidth: 1, marginRight: 20, marginLeft: 20, borderColor: '#838383' }}></View>
                </View>
                <View style={styles.body}>
                    <View style={styles.current_balance}>
                        <View style={{ flex: 1, margin: 10 }}>
                            <Text style={{ fontSize: 20, fontFamily: 'Gotham-Black', color: '#838383' }} >Balance</Text>
                        </View>
                        <View style={{ flex: 1, margin: 10 }}>
                            <Text style={{ fontSize: 20, fontFamily: 'Gotham-Black', color: '#838383' }}>{this.props.balance_redeem}</Text>
                        </View>
                    </View>
                    <View style={styles.current_balance}>
                        <View style={{ flex: 1, margin: 10 }}>
                            <Text style={{ fontSize: 20, fontFamily: 'Gotham-Black', color: '#838383' }} >Points</Text>
                        </View>
                        <View style={{ flex: 1, margin: 10 }}>
                            <Text style={{ fontSize: 20, fontFamily: 'Gotham-Black', color: '#838383' }}>{this.props.point_redeem}</Text>
                        </View>
                    </View>
                    {/* <View style={styles.redeem}>
                        <View style={{ flex: 1, margin: 10 }}>
                            <Text style={{ fontSize: 20 }} >Time</Text>
                        </View>
                        <View style={{ flex: 1, margin: 10 }}>
                            <Text style={{ fontSize: 20 }}>0:30</Text>
                        </View>
                    </View> */}
                    <TouchableOpacity onPress={() => this.cancel()}>
                        <View style={styles.button}>
                            <Text style={{ color: 'white', fontSize: 16, fontFamily: 'Gotham-Black' }}>Cancel Payment</Text>
                        </View>
                    </TouchableOpacity>
                </View>
            </View>
        )
    }
}


const styles = StyleSheet.create({

    container: {
        flex: 1,
        backgroundColor: '#ffff'
    },

    header: {
        flex: 0.5,
        margin: 10,
    },

    body: {
        flex: 3,
        margin: 10,
        marginTop: 0,
    },

    current_balance: {
        flexDirection: 'row',
        margin: 10,
    },

    redeem: {
        flexDirection: 'row',
        margin: 10
    },


    button: {
        backgroundColor: '#d34343',
        height: 40,
        marginTop: 25,
        marginHorizontal: 20,
        borderRadius: 10,
        paddingVertical: 5,
        alignItems: 'center',
        justifyContent: 'center'
    },

})

const mapStateToProps = (state) => {
    return {
        session_id: state.session_id,
        redeem_code: state.redeem_code,
        balance_redeem: state.balance_redeem,
        point_redeem: state.point_redeem
    }
}

const mapDispatchToProps = (dispacth) => {
    return {
        setRedeem: (redeemProps) => dispacth({
            type: ActionType.SET_REEDEM,
            data: {
                in_payment: redeemProps.in_payment,
                redeem_code: redeemProps.redeem_code,
                balance_redeem: redeemProps.balance_redeem,
                point_redeem: redeemProps.point_redeem
            }
        }),
    }
}

export default connect(mapStateToProps, mapDispatchToProps)(RedeemCode);