import React from 'react';
import { View, Text, StyleSheet, Button, Alert, TouchableOpacity } from 'react-native';
import { connect } from 'react-redux';
import Axios from 'axios';
import MyStatusBar from './MyStatusBar';

class Renewal extends React.Component {
    constructor(props) {
        super(props);
        this.state = {
            current_balance: "",
            expired: "",
            card_number: "",
            biaya_renewal: "100.000",
            renew_until: "",
        }
    }

    componentDidMount() {
        this._getProfile();
    }


    _renewal() {
        let params = {
            session_id: this.props.session_id
        }
        // console.log(params);
        Axios.post('https://excelsocrm.ravintoladev.com/crm/v2/card/renewal', params).then(res => {
            // console.log('ini res ' + JSON.stringify(res.data))
            this._getProfile();
            Alert.alert('Renewal Berhasil');
        }).catch(error => {
            let response = error.response.data;
            // console.log(response.msg)
            Alert.alert(response.msg);
        })
    }

    _getProfile() {
        let params = {
            session_id: this.props.session_id
        }

        Axios.post('https://excelsocrm.ravintoladev.com/crm/v2/member/get_profile', params).then(res => {
            // console.log('ini res ' + JSON.stringify(res.data))
            const dataCard = res.data

            let balance = dataCard.kaspro_balance
            let expired = dataCard.expire_date
            let c_renew_until = dataCard.expire_date

            var date_string = c_renew_until
            var date_arr = date_string.split('-');
            var date = new Date(date_arr[0], date_arr[1], date_arr[2]);
            
            date.setFullYear(date.getFullYear() + 1);
            let date_nextyear_string = date.getFullYear() + "-" + date.getMonth() + "-" + date.getDate()
            
            this.setState({
                current_balance: balance,
                expired: expired,
                renew_until: date_nextyear_string
            })



        }).catch(error => {
            // console.log('ini error ' + error)
        })
    }

    render() {
        return (
            <View style={styles.container}>
                <MyStatusBar />
                <View style={styles.header}>
                    {/* <Text style={{ textAlign: 'center', margin: 20, fontSize: 25, alignSelf: 'center' }}>Renewal</Text> */}
                </View>
                <View style={styles.body}>
                    <View style={styles.cont_curent_balance}>
                        <View style={styles.current_balance}>
                            <Text style={{ textAlign: 'center', fontSize: 12, fontFamily: 'Gotham-Black', color:'#CFB368' }}>Current Balance</Text>
                        </View>
                        <View style={styles.value_current_balance}>
                            <Text style={{ textAlign: 'center', fontSize: 12, fontFamily: 'Gotham-Black', color:'gray' }}>IDR {this.state.current_balance}</Text>
                        </View>
                    </View>
                    <View style={styles.cont_curent_balance}>
                        <View style={styles.current_balance}>
                            <Text style={{ textAlign: 'center', fontSize: 12, fontFamily: 'Gotham-Black', color:'#CFB368' }}>Biaya Renewal</Text>
                        </View>
                        <View style={styles.value_current_balance}>
                            <Text style={{ textAlign: 'center', fontSize: 12, fontFamily: 'Gotham-Black', color:'gray' }}>IDR {this.state.biaya_renewal}</Text>
                        </View>
                    </View>
                    <View style={styles.cont_curent_balance}>
                        <View style={styles.current_balance}>
                            <Text style={{ textAlign: 'center', fontSize: 12, fontFamily: 'Gotham-Black', color:'#CFB368' }}>Expired</Text>
                        </View>
                        <View style={styles.value_current_balance}>
                            <Text style={{ textAlign: 'center', fontSize: 12, fontFamily: 'Gotham-Black', color:'gray' }}>{this.state.expired}</Text>
                        </View>
                    </View>

                    <View style={styles.cont_curent_balance}>
                        <View style={styles.current_balance}>
                            <Text style={{ textAlign: 'center', fontSize: 12, fontFamily: 'Gotham-Black', color:'#CFB368' }}>Renew Until</Text>
                        </View>
                        <View style={styles.value_current_balance}>
                            <Text style={{ textAlign: 'center', fontSize: 12, fontFamily: 'Gotham-Black', color:'gray' }}>{this.state.renew_until}</Text>
                        </View>
                    </View>
                    {/* <View style={styles.btn_renewal}>
                        <Button title="Renew" onPress={() => this._renewal()}></Button>
                    </View> */}
                    <TouchableOpacity onPress={() => this._renewal()}>
                        <View style={styles.button}>
                            <Text style={{ color: 'white', fontSize: 12, fontFamily: 'Gotham-Black' }}>RENEW</Text>
                        </View>
                    </TouchableOpacity>
                </View>
            </View>
        )
    }
}


const styles = StyleSheet.create({
    container: {
        flex: 1,
        backgroundColor: 'white',
    },
    header: {
        flex: 0.1,
    },
    body: {
        flex: 0.9,
    },
    cont_curent_balance: {
        flex:0.2
    },
    current_balance: {
        flex: 1,
        // backgroundColor:'cyan',
        justifyContent:'center',
    },
    value_current_balance: {
        flex: 1,
        marginHorizontal:30,
        paddingHorizontal: 10,
        paddingVertical : 5,
        justifyContent:'center',
        borderWidth:1,
        borderColor:'gray',
        borderRadius:10,
        // backgroundColor:'maroon'
    },
    button: {
        flex: 0.2,
        backgroundColor: '#CFB368',
        marginTop: 20,
        marginHorizontal: 80,
        borderRadius: 15,
        padding: 20,
        alignItems: 'center',
        justifyContent: 'center'
    },
})

const mapStateToProps = (state) => {
    return {
        session_id: state.session_id,
    }
}
export default connect(mapStateToProps)(Renewal);
