import React from 'react';
import { View, Text, TextInput, StyleSheet, Button, Alert, Image, TouchableOpacity } from 'react-native';
import Axios from 'axios';
import { BASE_URL_RESET_PASSWORD } from '../model/Base_Model';
import ActionType from '../redux/globalActionType';
import { connect } from 'react-redux';
import i18n from 'i18n-js';
import Spinner from 'react-native-loading-spinner-overlay';
import MyStatusBar from './MyStatusBar';

class ResetPassword extends React.Component {
    constructor(props) {
        super(props);
        this.state = {
            email: '',
            language: 'id',
            spinner: false
        }
    }

    handleResetPassword() {
        this.setState({
            spinner: true,
        })
        let params = {
            'email': this.state.email
        }
        // console.log(this.state.email)
        Axios.post(BASE_URL_RESET_PASSWORD, params).then(res => {
            if (res.status === 200) {
                let resetProps = {
                    email: this.state.email
                }
                this.props.setResetPassword(resetProps);

                let isSubmit = {
                    isSubmitResetPassword: true
                }
                this.props.setChangeIsSubmit(isSubmit)

                this.setState({
                    spinner: false,
                })
                Alert.alert(
                    '',
                    'Email terkirim, mohon dicek'
                    ,
                )

                this.props.navigation.navigate('New Password');
            }
        }).catch(error => {
            this.setState({
                spinner: false,
            })
            let response = error.response.data;
            Alert.alert(response.msg);

        })
    }

    handleEnterToken() {
        if (this.props.isSubmitResetPassword == false) {
            Alert.alert('','Harap masukan email terlebih dahulu')
        } else {
            this.props.navigation.navigate('New Password');
        }
    }

    render() {
        return (
            <View style={styles.container}>
                <MyStatusBar />
                <Spinner
                    visible={this.state.spinner}
                    textContent={'Loading...'}
                    textStyle={styles.spinnerTextStyle}
                />
                <View style={{ flex: 3 }}>
                    <View style={{ flex: 1, marginRight: 30, marginLeft: 30, top: 50 }}>
                        <Text style={{ fontFamily: 'Gotham-Black', color: '#CFB368', fontSize: 20, textAlign: 'center', margin: 3 }}>Email</Text>
                        <TextInput style={{ height: 40, borderWidth: 1, padding: 5, margin: 10, borderRadius: 10, borderColor: 'grey', fontFamily: 'Gotham-Black', textAlign: 'center', color: 'grey', fontWeight: 'bold', fontSize: 20 }}
                            onChangeText={(email) => this.setState({ email })}
                            autoCapitalize="none"
                            value={this.state.email}
                            keyboardType='email-address' />
                        <TouchableOpacity style={{ height: 100 }} onPress={() => this.handleResetPassword()}>
                            <View style={{ backgroundColor: '#CFB368', height: 45, top: 20, borderRadius: 10, marginRight: 50, marginLeft: 50 }}>
                                <Text style={{ alignSelf: 'center', top: 10, color: 'white', fontFamily: 'Gotham-Black', fontSize: 20 }}>SUBMIT</Text>
                            </View>
                        </TouchableOpacity>
                        <TouchableOpacity style={{ height: 60 }} onPress={() => this.handleEnterToken()}>
                            <Text style={{ alignSelf: 'center', color: '#CFB368', fontFamily: 'Gotham-Black', fontSize: 20 }}>ENTER TOKEN</Text>
                        </TouchableOpacity>
                    </View>
                </View>
                <View style={{ flex: 1, flexDirection: 'row' }}>

                    <View style={styles.v_logo}>
                        <View style={{ flex: 1, alignSelf: 'flex-start' }}>
                            <Image resizeMode="contain" source={require('../assets/images/daun.png')} style={styles.logo}></Image>
                        </View>
                        <View style={{ flex: 1 }}>

                        </View>
                    </View>

                    <View style={{ flex: 0.5 }}>

                    </View>
                </View>
            </View>
        )
    }
}

const styles = StyleSheet.create({

    container: {
        flex: 1,
        backgroundColor: '#ffff'
    },

    header: {
        flex: 0.5,
        margin: 10,
    },

    form: {
        flex: 3,
        top: 40,
        margin: 10,
        marginTop: 0,
    },

    field_email: {
        flexDirection: 'row'
    },

    button: {
        height: 40,
        margin: 10,

    },
    logo: {
        alignSelf: 'flex-start',
        marginTop: 50,
        width: 290,
        height: 290,
        bottom: 145,

    },
    v_logo: {
        flex: 2,
        flexDirection: 'column-reverse',
        alignContent: 'flex-start',
    }
})

const mapStateToProps = (state) => {
    return {
        email: state.email,
        language: state.language,
        isSubmitResetPassword: state.isSubmitResetPassword
    }
}

const mapDispatchToProps = (dispacth) => {
    return {
        setResetPassword: (registerProps) => dispacth({
            type: ActionType.SET_RESET_PASSWORD,
            data: {
                email: registerProps.email,
            }
        }),
        setChangeIsSubmit: (isSubmitProps) => dispacth({
            type: ActionType.SET_CHANGE_RESET_PASSWORD,
            data: {
                isSubmitResetPassword: isSubmitProps.isSubmitResetPassword
            }
        })
    }
}

export default connect(mapStateToProps, mapDispatchToProps)(ResetPassword);


{/* <Spinner
visible={this.state.spinner}
textContent={'Loading...'}
textStyle={styles.spinnerTextStyle}
/>
<Text style={{ textAlign: 'center', marginTop: 10, fontSize: 25 }}>{i18n.t('resetPassword')}</Text>
<View style={styles.form}>
<View style={styles.field_email}>
    <View style={{ flex: 1 }}>
        <TextInput style={{ height: 40, borderWidth: 1, padding: 5, margin: 10, borderRadius:20 }}
            onChangeText={(email) => this.setState({ email })}
            autoCapitalize="none"
            value={this.state.email} 
            keyboardType='email-address'/>
    </View>
</View>
<View style={styles.button}>
    <Button title={i18n.t('submit')} onPress={() => this.handleResetPassword()}></Button>
    <View></View>
</View>
<TouchableOpacity onPress={() => this.handleResetPassword()}>
    <Text style={{ fontSize: 20, textAlign: 'center', color: 'red' }}>{i18n.t('enterToken')}</Text>
</TouchableOpacity>
</View> */}