import React from 'react';
import { View, Text, Alert, TextInput, StyleSheet, Button, ScrollView } from 'react-native';
import Axios from 'axios'
import { connect } from 'react-redux'
import ActionType from '../redux/globalActionType';
import Spinner from 'react-native-loading-spinner-overlay';
import session from '../function/session';
class MenuConfirmation extends React.Component {
    constructor(props) {
        super(props)
        this.state = {
            kasproBalance: '',
            kasproPoint: '',
            balanceused: 0,
            pointsused: 0,
            ongkir: 0,
            diskon: 0,
            totalOrder: 0,
            type: '',
            spinner: false,
        }
    }

    componentDidMount() {
        // console.log(" DESTINASI : "+ this.props.grabdestination)
        // console.log("ONGKIR"+ this.props.grabamount)
        // console.log("drop off"+this.props.grabdropoff)
        // console.log("pickup"+this.props.grabpickup)
        // console.log("type" +this.props.grabtype)
        // console.log("BALANCED" +this.props.balanceUsed)
        // console.log("POINT" +this.props.pointsused)


    }

    setOrder(is_pickup) {
        this.setState({
            spinner: true,
        })
        if (is_pickup) {
            this.setState({
                type: 'Pick Up'
            })
        } else {
            this.setState({
                type: 'Delivery'
            })
        }
        // console.log(is_pickup)

        if (this.props.value_voucher == '') {
            let params = {
                session_id: this.props.session_id,
                outlet_id: this.props.outlet_id,
                address_id: this.props.addressId,
                trans_type: this.state.type,
                order_item: this.props.order_item,
                delivery_charge: this.props.grabamount,
                voucher: [],
                payment: {
                    balance: this.props.route.params.balanceUsed,
                    point: this.props.route.params.pointused
                }
            }

            console.log(params)

            Axios.post('https://excelsocrm.ravintoladev.com/crm/v2/transaction/booking', params).then(res => {
                let data_order = res.data.data.id

                this.setState({
                    spinner: false,
                })
                let transIdProps = {
                    trans_id: data_order
                }
                this.props.setTransId(transIdProps);

                // add API use voucher here
                // let param = {
                //     session_id: this.props.session_id,
                //     reward_id: this.props.voucher.id,
                //     lat: this.props.lat,
                //     long: this.props.long
                // }

                // Axios.post('https://excelsocrm.ravintoladev.com/crm/v2/reward/use_reward', param).then(res => {
                //         console.log(res.data)
                // }).catch(error => {
                //     const { navigation } = this.props
                //     let response = error.response.data
                //     session(response, navigation)
                //     Alert.alert(response.msg);
                //     this.setState({
                //         spinner: false,
                //     })
                // })

                Alert.alert(
                    "Berhasil",
                    "Transaksi sudah berhasil, terimakasih sudah menggunakan excelso untuk ngopi",
                    [
                        { text: "OK", onPress: () => this.orderSuccess() }

                    ],
                    { cancelable: false }
                );
            }).catch(error => {
                const { navigation } = this.props
                let response = error.response.data
                session(response, navigation)
                Alert.alert(response.msg);
                this.setState({
                    spinner: false,
                })
            })

        } else {
            let params = {
                session_id: this.props.session_id,
                outlet_id: this.props.outlet_id,
                address_id: this.props.addressId,
                trans_type: this.state.type,
                order_item: this.props.order_item,
                delivery_charge: this.props.grabamount,
                voucher: [{
                    value: this.props.voucher.reward.value,
                    verification_number: this.props.voucher.verification_number
                }],
                payment: {
                    balance: this.props.route.params.balanceUsed,
                    point: this.props.route.params.pointused
                }
            }

            console.log(params)

            Axios.post('https://excelsocrm.ravintoladev.com/crm/v2/transaction/booking', params).then(res => {
                let data_order = res.data.data.id

                this.setState({
                    spinner: false,
                })
                let transIdProps = {
                    trans_id: data_order
                }
                this.props.setTransId(transIdProps);

                // add API use voucher here
                // let param = {
                //     session_id: this.props.session_id,
                //     reward_id: this.props.voucher.id,
                //     lat: this.props.lat,
                //     long: this.props.long
                // }

                // Axios.post('https://excelsocrm.ravintoladev.com/crm/v2/reward/use_reward', param).then(res => {
                //         console.log(res.data)
                // }).catch(error => {
                //     const { navigation } = this.props
                //     let response = error.response.data
                //     session(response, navigation)
                //     Alert.alert(response.msg);
                //     this.setState({
                //         spinner: false,
                //     })
                // })

                Alert.alert(
                    "Berhasil",
                    "Transaksi sudah berhasil, terimakasih sudah menggunakan excelso untuk ngopi",
                    [
                        { text: "OK", onPress: () => this.orderSuccess() }

                    ],
                    { cancelable: false }
                );
            }).catch(error => {
                const { navigation } = this.props
                let response = error.response.data
                session(response, navigation)
                Alert.alert(response.msg);
                this.setState({
                    spinner: false,
                })
            })
        }
    }

    orderSuccess = () => {
        this.props.setOrderFinish()
        this.props.navigation.navigate('Order Detail');
        // this.props.navigation.reset({
        //     routes: [{ name: 'Home' }]
        // })
    }


    render() {
        // console.log(this.props.value_voucher)
        let total = 0
        return (
            <ScrollView style={styles.container}>
                <Spinner
                    visible={this.state.spinner}
                    textContent={'Sedang Proses...'}
                    textStyle={styles.spinnerTextStyle}
                />
                {
                    this.props.order_item.map((item, index) => {
                        total = total + item.quantity * item.price
                        return (
                            <View style={{ margin: 10 }} key={index}>
                                <View style={{ flex: 1, margin: 10, flexDirection: 'row', justifyContent: 'space-around' }}>
                                    <View style={{ flex: 0.3, alignItems: 'center' }}>
                                        <Text>{item.quantity}</Text>
                                    </View>
                                    <View style={{ flex: 0.1, alignItems: 'flex-start' }}>
                                        <Text>x</Text>
                                    </View>
                                    <View style={{ flex: 0.3, alignItems: 'baseline' }}>
                                        <Text>{item.name} </Text>
                                    </View>
                                    <View style={{ flex: 0.3, alignItems: 'flex-end' }}>
                                        <Text>{item.quantity * item.price} </Text>
                                    </View>
                                </View>
                            </View>
                        )
                    })
                }
                <View style={{ alignItems: 'flex-end', borderTopWidth: 1, margin: 10, padding: 10 }}>
                    <Text>{total}</Text>
                </View>
                <View style={{ flexDirection: 'row', margin: 10, justifyContent: 'space-between' }}>
                    <View style={{ margin: 10 }}>
                        <Text>Voucher Discount</Text>
                    </View>
                    <View style={{ margin: 10 }}>
                        {
                            this.props.value_voucher == '' ? (
                                <Text>0</Text>
                            ) : (
                                    <Text>{this.props.voucher.reward.value}</Text>
                                )
                        }

                    </View>
                </View>
                <View style={{ flexDirection: 'row', margin: 10, justifyContent: 'space-between' }}>

                    {this.props.type_pickup == true ? (
                        null
                    ) : (
                            <View>
                                <View style={{ margin: 10 }}>
                                    <Text>Delivery Charge</Text>
                                </View>

                                <View style={{ margin: 10 }}>
                                    <Text>{this.props.grabamount}</Text>
                                </View>
                            </View>
                        )}

                </View>
                <View style={{ flexDirection: 'row', margin: 10, justifyContent: 'space-between', borderTopWidth: 1 }}>
                    <View style={{ margin: 10 }}>
                        <Text>Total</Text>
                    </View>
                    {this.props.type_pickup == true ? (
                        <View style={{ margin: 10 }}>
                            {
                                this.props.value_voucher == '' ? (
                                    <Text>{this.props.order_total}</Text>
                                ) : (
                                        <Text>{Math.max(0, this.props.order_total - this.props.voucher.reward.value)}</Text>
                                    )
                            }
                        </View>
                    ) : (
                            <View style={{ margin: 10 }}>
                                {
                                    this.props.value_voucher == '' ? (
                                        <Text>{this.props.order_total + this.props.grabamount + this.state.diskon}</Text>
                                    ) : (
                                            <Text>{Math.max(this.props.order_total + this.props.grabamount - this.props.voucher.reward.value)}</Text>
                                        )
                                }

                            </View>
                        )}

                </View>
                <View style={{ flexDirection: 'row', margin: 10, justifyContent: 'space-between', borderTopWidth: 1 }}>
                    <View style={{ margin: 10 }}>
                        <Text>Balance Used</Text>
                    </View>
                    <View style={{ margin: 10 }}>
                        <Text>{this.props.route.params.balanceUsed}</Text>
                    </View>
                </View>
                <View style={{ flexDirection: 'row', margin: 10, justifyContent: 'space-between' }}>
                    <View style={{ margin: 10 }}>
                        <Text>Point Used</Text>
                    </View>
                    <View style={{ margin: 10 }}>
                        <Text>{this.props.route.params.pointused}</Text>
                    </View>
                </View>
                {this.props.type_pickup == true ? (
                    null
                ) : (
                        <View style={{ flexDirection: 'row', margin: 10, justifyContent: 'space-between' }}>
                            <View style={{ margin: 10 }}>
                                <Text>Delivery to</Text>
                            </View>
                            <View style={{ margin: 10 }}>
                                <Text>{this.props.address}</Text>
                            </View>
                        </View>
                    )}
                <View style={{ margin: 10 }}>
                    <Button title='order' onPress={() => this.setOrder(this.props.type_pickup)} />
                </View>
            </ScrollView>
        )
    }
}

const styles = StyleSheet.create({

    container: {
        flex: 1,
        backgroundColor: 'white',
    },
    header: {

        flex: 0.5,
    },
    images: {
        margin: 10,
        flex: 2,
        backgroundColor: 'green'
    },
    content: {
        flex: 2,
    },
    body: {
        flex: 3,
    },

})


const mapDispatchToProps = (dispacth) => {
    return {
        setOrderFinish: () => dispacth({
            type: ActionType.SET_ORDER_FINISH
        }),
        setTransId: (transIdProps) => dispacth({
            type: ActionType.SET_TRANS_ID,
            data: {
                trans_id: transIdProps.trans_id,
            }
        })
    }
}

const mapStateToProps = (state) => {
    // console.log(state)
    return {
        session_id: state.session_id,
        value_voucher: state.value_voucher,
        voucher: state.voucher,
        type_pickup: state.type_pickup,
        outlet_id: state.outlet_id,
        order_quantity: state.order_quantity,
        order_total: state.order_total,
        order_item: state.order_item,
        quantity: state.quantity,
        address: state.address,
        grabtype: state.grabtype,
        grabamount: state.grabamount,
        grabpickup: state.grabpickup,
        grabdropoff: state.grabdropoff,
        grabdestination: state.grabdestination,
        balanceUsed: state.balanceUsed,
        pointused: state.pointused,
        addressId: state.addressId,
        lat: state.lat,
        long: state.long
    }
}

export default connect(mapStateToProps, mapDispatchToProps)(MenuConfirmation)
