import Icon from "react-native-vector-icons/Ionicons"
import React, { useEffect, useRef, useState } from "react"
import { ImageBackground, SafeAreaView, StatusBar, Text, View, TouchableOpacity } from "react-native"
import ReactNativePinView from "react-native-pin-view"
import { MaterialCommunityIcons } from '@expo/vector-icons';
const PinRequest = () => {
    const pinView = useRef(null)
    const [showRemoveButton, setShowRemoveButton] = useState(false)
    const [enteredPin, setEnteredPin] = useState("")
    const [showCompletedButton, setShowCompletedButton] = useState(false)
    useEffect(() => {
        if (enteredPin.length > 0) {
            setShowRemoveButton(true)
        } else {
            setShowRemoveButton(false)
        }
        if (enteredPin.length === 6) {
            setShowCompletedButton(true)
            alert("Entered Pin: " + enteredPin)
        } else {
            setShowCompletedButton(false)
        }
    }, [enteredPin])
    return (
        <>
            {/* <StatusBar barStyle="light-content" /> */}
            <View style={{ flex: 1, backgroundColor: "white", marginHorizontal: 10 }}>
                <View style={{ flex: 0.2, alignItems: 'center', justifyContent: 'center' }}>
                    <View>
                        <Text
                            style={{
                                fontFamily: 'Gotham-Black',
                                color: "#838383",
                                fontSize: 20,
                            }}>
                            INPUT YOUR SECURITY CODE
                            </Text>
                    </View>
                    <View style={{ paddingTop: 10 }}>
                        <TouchableOpacity>
                            <Text
                                style={{
                                    fontFamily: 'Gotham-Black',
                                    color: "#CFB368",
                                    fontSize: 14,
                                }}>
                                FORGOT YOUR SECURITY CODE?
                            </Text>
                        </TouchableOpacity>
                    </View>
                </View>
                <View style={{ flex: 0.8 }}>
                    <ReactNativePinView
                        inputSize={30}
                        ref={pinView}
                        pinLength={6}
                        buttonSize={90}
                        onValueChange={value => setEnteredPin(value)}
                        buttonAreaStyle={{
                            marginTop: 24
                        }}
                        inputAreaStyle={{

                        }}
                        inputViewEmptyStyle={{
                            backgroundColor: "transparent",
                            borderWidth: 1,
                            borderColor: "#CFB368",
                        }}
                        inputViewFilledStyle={{
                            backgroundColor: "#CFB368",
                        }}
                        buttonViewStyle={{

                        }}
                        buttonTextStyle={{
                            fontFamily: 'Gotham-Black',
                            color: "#838383",
                            fontSize: 70,
                        }}
                        onButtonPress={key => {
                            // if (key === "custom_left") {
                            //     pinView.current.clear()
                            // }
                            if (key === "custom_right") {
                                // alert("Entered Pin: " + enteredPin)
                                pinView.current.clear()
                            }
                            // if (key === "three") {
                            //     alert("You can't use 3")
                            // }
                        }}
                        // customLeftButton={showRemoveButton ? <Icon name={"ios-backspace"} size={36} color={"#838383"} /> : undefined}
                        customLeftButtonDisabled
                        customRightButton={<MaterialCommunityIcons name="backspace-outline" size={45} color="#838383" />}
                    />
                </View>
            </View>
        </>
    )
}
export default PinRequest