import React from 'react';
import { View, Text, TextInput, StyleSheet, ScrollView, Alert, TouchableOpacity } from 'react-native';
import { Card } from 'react-native-shadow-cards'
import { connect } from 'react-redux';
import Axios from 'axios';
import moment from 'moment'

class TransactionHistory extends React.Component {
    constructor(props) {
        super(props)
        this.state = {
            history_list: []
        }
    }

    componentDidMount() {
        this.getTransactionHistory()
    }

    getTransactionHistory() {
        let params = {
            session_id: this.props.session_id
        }
        Axios.post('https://excelsocrm.ravintoladev.com/crm/v2/transaction/history', params).then(res => {
            let data = res.data.transactions
            // console.log('ini datanya loh : ' + JSON.stringify(data))
            this.setState({
                history_list: data
            })

        }).catch(error => {
            let response = error.response.data;
            Alert.alert(response.msg);
        })
    }

    render() {
        return (
            <View style={styles.container}>
                <ScrollView style={styles.body}>
                    {
                        this.state.history_list.length ? (
                            this.state.history_list.map((item) => (

                                item.transactions.map((i, k) => (
                                    <TouchableOpacity key={k} onPress={() => this.props.navigation.navigate('Transaction Detail', { idTrans: i.id })}>
                                        <View style={{ marginTop: 5 }} key={k}>
                                            <View style={{ flex: 2, height: 120, margin: 5, borderRadius: 5, borderWidth: 1, flexDirection: 'row' }}>
                                                <View style={{ justifyContent: 'center', margin: 10 }}>
                                                    <Text style={{ fontFamily: 'Gotham-Black', color: 'grey', fontSize: 12, margin: 2 }}>{i.outlet}</Text>
                                                    <Text style={{ fontFamily: 'Gotham-Light', color: 'grey', fontSize: 12, margin: 2 }}>{moment(i.trans_time).format("DD MMMM YYYY, hh:mm A")}</Text>
                                                    <Text style={{ fontFamily: 'Gotham-Black', color: '#c9af6d', fontSize: 12, margin: 2 }}>{i.trans_type_display}</Text>
                                                    <TouchableOpacity onPress={() => this.props.navigation.navigate('Transaction Detail', { idTrans: i.id })}>
                                                        <View style={{ height: 40, borderRadius: 10, backgroundColor: '#CFB368', justifyContent: 'center' }}>
                                                            <Text style={{ fontFamily: 'Gotham-Black', color: 'white', fontSize: 12, textAlign: 'center', margin: 15 }}>Lihat Detail Transaksi</Text>
                                                        </View>
                                                    </TouchableOpacity>
                                                </View>
                                                <View style={{ justifyContent: 'center', marginVertical: 5, marginLeft: 20, borderLeftWidth: 1, borderColor: 'grey' }}>
                                                    <View style={{ margin: 30 }}>
                                                        <Text style={{ fontFamily: 'Gotham-Black', color: '#c9af6d', fontSize: 12, margin: 2 }}>{i.trans_status_display}</Text>
                                                    </View>
                                                </View>
                                            </View>
                                        </View>
                                    </TouchableOpacity>
                                ))
                            ))
                        ) : (
                                <View style={{ justifyContent: 'center', alignItems: 'center', height: 100 }}>
                                    <Text style={{ textAlign: 'left', fontSize: 12, fontFamily: 'Gotham-Light', color: 'grey' }}>No Transaction History</Text>
                                </View>
                            )
                    }
                </ScrollView>
            </View>
        )
    }
}

const styles = StyleSheet.create({
    container: {
        flex: 1,
        backgroundColor: 'white',
    },
    header: {

        flex: 0.2,
    },

    body: {
        flex: 3,
        margin: 5,
    },
    list_detail_order: {
        flex: 1,
        margin: 20,
        borderWidth: 1,
    }
})

const mapStateToProps = (state) => {
    return {

        session_id: state.session_id,

    }
}

export default connect(mapStateToProps)(TransactionHistory);