import React from 'react';
import { View, Text, StyleSheet, ScrollView, TouchableOpacity, Image, TextInput, Modal, Alert } from 'react-native';
import { connect, connectAdvanced } from 'react-redux';
import ActionType from '../redux/globalActionType';
import NumberFormat from 'react-number-format';
import { Icon } from 'react-native-elements'


class Item extends React.Component {

    constructor(props) {
        super(props)
        this.state = {
            value: 0,
            modalVisible: false,
            notes: ''
        }
    }
    handleChangeQuantity = (item, qty) => {

        if (qty == '') {
            item.qty = 0
        } else {

            const order_item = {
                id: item.id,
                code: item.code,
                name: item.name,
                description: item.description,
                image: item.image,
                price: parseInt(item.price),
            }

            this.props.changeQuantity({ item: order_item, quantity: qty })
        }
    }

    handleAddDescription() {
        this.setState({
            modalVisible: true
        })
    }

    handleEdit = (item) => {
        let note = ''
        if (this.state.notes == '') {
            note = '';
        } else {
            note = this.state.notes;
        }
        const order_item = {
            id: item.id,
            note: note,
        }
        this.props.setNotes({ item: order_item })
        this.setState({
            modalVisible: false
        })
    }

    render() {
        const { item } = this.props

        return (
            <View style={{ flex: 1, margin: 10 }} key={item.id} ref={this.props._scrollView}>

                <ScrollView ref={view => this._scrollView = view}>
                    {item.code == 'CATEGORY' ? (
                        <Text style={{ fontSize: 15, color: '#c9af6d', fontFamily: 'Gotham-Black' }}>{item.name}</Text>
                    ) : (
                            <View style={{ flex: 1, flexDirection: 'row'  }}>
                                <Modal animationType="slide"
                                    transparent={true}
                                    visible={this.state.modalVisible}
                                    onRequestClose={() => {
                                        this.setState({
                                            modalVisible: false
                                        })
                                    }}>
                                    <View style={styles.centerViewModal}>
                                        <View style={styles.modalView}>
                                            <Text style={{ fontSize: 12, color: '#CFB368', fontFamily: 'Gotham-Black' }}>Add Description</Text>
                                            <View style={{ margin: 10 }}>
                                                <TextInput
                                                    style={styles.textInput}
                                                    onChangeText={(notes) => this.setState({ notes })}
                                                    textAlign='center'

                                                >
                                                    {item.note}
                                                </TextInput>
                                            </View>
                                            <View style={{ flexDirection: 'row' }}>
                                                <TouchableOpacity style={{ margin: 5 }} onPress={() => this.handleEdit(item)}>
                                                    <View style={styles.button}>
                                                        <Text style={{ color: 'white', fontWeight: 'bold', fontSize: 16 }}>CONFIRM</Text>
                                                    </View>
                                                </TouchableOpacity>
                                                <TouchableOpacity style={{ margin: 5 }} onPress={() => this.setState({ modalVisible: false })}>
                                                    <View style={styles.button}>
                                                        <Text style={{ color: 'white', fontWeight: 'bold', fontSize: 16 }}>CANCEL</Text>
                                                    </View>
                                                </TouchableOpacity>
                                            </View>
                                        </View>
                                    </View>
                                </Modal>
                                <View style={{ flex: 1 }}>
                                    <TouchableOpacity onPress={() => this.props.navigation.navigate('Menu Detail', { nameMenu: item.name, desc: item.description, image: item.image })}>
                                        <Image source={{ uri: item.image }} style={{ height: 100, width: 100, borderRadius: 10, }}></Image>
                                    </TouchableOpacity>
                                </View>
                                <View style={{ flex: 2  }}>
                                    <View style={{ marginLeft: 5, marginRight: 5 }}>
                                        {
                                            item.motm ? (
                                                <View style={{ marginLeft: 5, flexDirection: 'row', alignItems: 'center' }}>
                                                    <Icon
                                                        name='star'
                                                        type='font-awesome'
                                                        color='#CFB368'
                                                        size={14}
                                                    />
                                                    <Text style={{ fontSize: 14, margin: 5, marginRight: 10, fontFamily: 'Gotham-Black', color: '#838383' }}>{item.name}</Text>
                                                </View>
                                            ) : (
                                                    <Text style={{ fontSize: 14, margin: 5, marginRight: 10, fontFamily: 'Gotham-Black', color: '#838383' }}>{item.name}</Text>
                                                )
                                        }

                                        <NumberFormat decimalScale={0} value={item.price} renderText={value => <Text style={{ fontSize: 14, margin: 5, marginRight: 10, fontFamily: 'Gotham-Light', color: 'grey' }}>Rp. {value}</Text>} displayType={'text'} thousandSeparator={true} prefix={''} />
                                    </View>
                                    <View style={{ marginLeft: 5, marginRight: 5, flexDirection: 'row' }}>
                                        {
                                            item.sold_out == true ? (
                                                <Text style={{ fontSize: 14, margin: 5, marginRight: 10, fontFamily: 'Gotham-Black', color: '#838383' }}>Sold Out</Text>
                                            ) : (
                                                    <>
                                                        <TouchableOpacity style={{ justifyContent: 'center' }} onPress={() => this.handleAddDescription()}>
                                                            <View style={styles.shadowEdit}>
                                                                <Icon
                                                                    name='pencil'
                                                                    type='simple-line-icon'
                                                                    color='#838383'
                                                                    size={18}
                                                                />
                                                            </View>
                                                        </TouchableOpacity>
                                                        <View style={styles.shadowAdd}>
                                                            <TouchableOpacity style={{ alignSelf: 'center' }} onPress={() => this.props.handleMin()}>
                                                                <Icon
                                                                    name='minus'
                                                                    type='font-awesome'
                                                                    color='#CFB368'
                                                                    size={18}
                                                                />
                                                            </TouchableOpacity>
                                                            <TextInput
                                                                style={{ padding: 2, textAlign: 'center', fontFamily: 'Gotham-Black', color: '#838383', fontSize: 14, marginRight: 5, marginLeft: 5 }}
                                                                keyboardType={'numeric'}
                                                                onChangeText={(qty) => this.handleChangeQuantity(item, qty)}>{item.qty}</TextInput>
                                                            <TouchableOpacity style={{ alignSelf: 'center' }} onPress={() => this.props.handleAdd()}>
                                                                <Icon
                                                                    name='plus'
                                                                    type='font-awesome'
                                                                    color='#CFB368'
                                                                    size={18}
                                                                />
                                                            </TouchableOpacity>
                                                        </View>
                                                    </>
                                                )
                                        }

                                    </View>
                                    {
                                        item.note != undefined && item.note != '' ? (
                                            <View style={{ marginLeft: 5, marginRight: 5 }}>
                                                <Text style={{ fontSize: 12, marginTop: 8, marginHorizontal:5, fontFamily: 'Gotham-Light', color: '#838383' }}>{item.note}</Text> 
                                            </View>
                                        ):( false )
                                    }
                                    
                                </View>
                            </View>
                        )}
                </ScrollView>
            </View >
        )
    }
}

const styles = StyleSheet.create({
    shadowEdit: {
        height: 30,
        width: 40,
        borderWidth: 1,
        borderRadius: 2,
        borderColor: '#ddd',
        // borderBottomWidth: 0,
        // shadowColor: '#000',
        // shadowOffset: { width: 0, height: 1 },
        // shadowOpacity: 0.1,
        // shadowRadius: 2,
        // elevation: 0.5,
        marginLeft: 5,
        marginRight: 5,
        marginTop: 5,
        justifyContent: 'center'
    },
    shadowAdd: {
        height: 30,
        width: 90,
        borderWidth: 1,
        borderRadius: 2,
        borderColor: '#ddd',
        // borderBottomWidth: 0,
        // shadowColor: '#000',
        // shadowOffset: { width: 0, height: 1 },
        // shadowOpacity: 0.1,
        // shadowRadius: 2,
        // elevation: 0.5,
        marginLeft: 5,
        marginRight: 5,
        marginTop: 5,
        flexDirection: 'row',
        justifyContent: 'center'
    },
    shadowMin: {
        height: 20,
        width: 20,
        borderWidth: 1,
        borderRadius: 2,
        borderColor: '#ddd',
        // borderBottomWidth: 0,
        // shadowColor: '#000',
        // shadowOffset: { width: 0, height: 1 },
        // shadowOpacity: 0.1,
        // shadowRadius: 2,
        // elevation: 1,
        marginLeft: 5,
        marginRight: 5,
        marginTop: 5,
        justifyContent: 'center'
    },
    centerViewModal: {
        flex: 1,
        justifyContent: "center",
        alignItems: "center",
    },
    modalView: {
        backgroundColor: "white",
        borderRadius: 10,
        borderWidth: 1,
        borderColor: 'grey',
        padding: 20,
        alignItems: "center",
    },
    textInput: {
        height: 40,
        width: 250,
        fontFamily: 'Gotham-Light',
        fontSize: 14,
        color: '#838383',
        borderColor: 'gray',
        borderWidth: 1,
        marginHorizontal: 30,
        borderRadius: 10
    },
    button: {
        backgroundColor: '#CFB368',
        height: 40,
        paddingHorizontal: 20,
        borderRadius: 10,
        alignItems: 'center',
        justifyContent: 'center'
    },
})

const mapDispatchToProps = (dispacth) => {
    return {
        setChangeQuantity: (item) => dispacth({
            type: ActionType.CHANGE_TO_CHART,
            data: {
                item: item
            }
        }),
        changeQuantity: (params) => dispacth({
            type: ActionType.CHANGE_QUANTITY,
            data: {
                item: params.item,
                new_quantity: params.quantity
            }
        }),
        setNotes: (params) => dispacth({
            type: ActionType.SET_EDIT_NOTE,
            data: {
                item: params.item,
            }
        }),
    }
}
const mapStateToProps = (state) => {
    // console.log(state)
    return {
        session_id: state.session_id,
        outlet_id: state.outlet_id,
        order_quantity: state.order_quantity,
        order_total: state.order_total,
        quantity: state.quantity,
        menu_item: state.menu_item
    }
}

export default connect(mapStateToProps, mapDispatchToProps)(Item)
