import React from 'react';
import { View, Text, BackHandler, StyleSheet, ScrollView, Alert, TouchableOpacity, ActivityIndicator } from 'react-native';
import { connect } from 'react-redux';
import Axios from 'axios';
import i18n from 'i18n-js';
import moment from 'moment'


class InboxList extends React.Component {

    constructor(props) {
        super(props)
        this.handleBackButtonClick = this.handleBackButtonClick.bind(this)
        this.state = {
            inbox_list: [],
            indicator: true
        }
    }

    componentDidMount() {
        BackHandler.addEventListener('hardwareBackPress', this.handleBackButtonClick);
        this.getInbox()
        this._unsubscribe = this.props.navigation.addListener('focus', () => {

            this.setState({
                indicator: true,
            })
            this.getInbox()
        });
    }

    componentWillUnmount() {
        BackHandler.removeEventListener('hardwareBackPress', this.handleBackButtonClick);
        this._unsubscribe()
    }

    handleBackButtonClick() {
        this.props.navigation.navigate('Home', { screen: 'HOME' })
        return true;
    }

    getInbox() {
        let params = {
            session_id: this.props.session_id
        }
        Axios.post(this.props.BASE_URL + 'crm/v2/inbox/get_list', params).then(res => {
            let data = res.data.messages
            // console.log(data)

            this.setState({
                inbox_list: data,
                indicator: false
            })

        }).catch(error => {
            let response = error.response.data
            Alert.alert('', response.msg);
            this.setState({
                indicator: false,
            })
        })
    }

    render() {
        return (
            <View style={styles.container}>
                <ScrollView style={styles.body}>
                    {
                        this.state.indicator ? (<ActivityIndicator style={{ justifyContent: "center", marginTop: 100 }} size="large" color="#c9af6d" />) :
                            this.state.inbox_list.length ? (
                                this.state.inbox_list.map((item, key) => (
                                    item.read !== 0 ? (
                                        <TouchableOpacity key={key} onPress={() => this.props.navigation.navigate('Inbox Detail', { idInbox: item.id })}>
                                            <View style={{ flex: 1, flexDirection: 'row', justifyContent: 'space-between', borderBottomWidth: 1, borderColor: '#838383', padding: 15 }} key={key}>
                                                <View style={{ flex: 0.7 }}>
                                                    <Text style={{ textAlign: 'left', fontSize: 18, fontFamily: 'Gotham-Light', color: 'grey' }}>{item.message.title}</Text>
                                                    <Text style={{ textAlign: 'left', fontSize: 14, fontFamily: 'Gotham-Light', color: 'grey' }}>{item.message.subtitle}</Text>
                                                </View>
                                                <View style={{ flex: 0.3, justifyContent: 'center', alignItems: 'flex-end' }}>
                                                    <Text style={{ fontFamily: 'Gotham-Light', color: 'grey', fontSize: 18 }}>{moment(item.sent_time).format("DD MMM")}</Text>
                                                </View>
                                            </View>
                                        </TouchableOpacity>
                                    ) : (
                                            <TouchableOpacity key={key} onPress={() => this.props.navigation.navigate('Inbox Detail', { idInbox: item.id })}>
                                                <View style={{ flex: 1, flexDirection: 'row', justifyContent: 'space-between', borderBottomWidth: 1, borderColor: '#838383', padding: 15 }} key={key}>
                                                    <View style={{ flex: 0.7 }}>
                                                        <Text style={{ textAlign: 'left', fontSize: 18, fontFamily: 'Gotham-Black', color: 'grey' }}>{item.message.title}</Text>
                                                        <Text style={{ textAlign: 'left', fontSize: 14, fontFamily: 'Gotham-Black', color: 'grey' }}>{item.message.subtitle}</Text>
                                                    </View>
                                                    <View style={{ flex: 0.3, justifyContent: 'center', alignItems: 'flex-end' }}>
                                                        <Text style={{ fontFamily: 'Gotham-Black', color: 'grey', fontSize: 18 }}>{moment(item.sent_time).format("DD MMM")}</Text>
                                                    </View>
                                                </View>
                                            </TouchableOpacity>
                                        )

                                ))
                            ) : (
                                    <View style={{ justifyContent: 'center', alignItems: 'center', marginTop: 100 }}>
                                        <Text style={{ textAlign: 'left', fontSize: 12, fontFamily: 'Gotham-Light', color: 'grey' }}>{i18n.t('noInboxData')}</Text>
                                    </View>
                                )

                    }

                </ScrollView>




            </View>
        )

    }




}

const styles = StyleSheet.create({
    container: {
        flex: 1,
        backgroundColor: 'white',
    },
    header: {
        flex: 0.1,
        backgroundColor: '#ccb46c',
        justifyContent: 'center'
    },

    body: {
        flex: 3,
        margin: 10,
    },
    list_detail_order: {
        flex: 1,
        margin: 20,
        borderWidth: 1,
    }
})

const mapStateToProps = (state) => {
    return {

        session_id: state.session_id,
        language: state.language,
        BASE_URL: state.BASE_URL,

    }
}

export default connect(mapStateToProps)(InboxList);