import React from 'react';
import { View, Text, StyleSheet, ScrollView, TouchableOpacity, Image, TextInput } from 'react-native';
import { connect } from 'react-redux';

class ItemShoping extends React.Component {

    render() {
        const { item } = this.props
        return (
            
            <View style={{ flex: 1, margin: 10 }} key={item.id}>
                    {/* <Text style={{ fontSize: 20, color: '#c9af6d' }}>{item.name}</Text> */}
                    <View style={{ flexDirection: 'row' }}>
                        <View >
                            <Image source={{ uri: item.image }} style={{ height: 100, width: 100, borderRadius: 5, top: 5 }}></Image>
                        </View>
                        <View >
                            <Text style={{ fontSize: 20, margin: 5, marginRight: 10, fontWeight: 'bold' }}>{item.name}</Text>
                            <Text style={{ fontSize: 15, margin: 5, marginRight: 10 }}>Rp. {item.price}</Text>
                            <View style={{ flexDirection: 'row', flex: 1 }}>
                                <View style={styles.shadowEdit}></View>
                                <View style={styles.shadowAdd}>
                                    <TouchableOpacity onPress={() => this.props.handleMin()}>
                                        <Text style={{ fontSize: 20, margin: 2 }}> - </Text>
                                    </TouchableOpacity>
                                    <TextInput
                                        style={{ height: 25, padding: 2, textAlign: 'center', margin: 2 }}
                                        autoCapitalize="none">
                                        {item.quantity}
                                    </TextInput>
                                    <TouchableOpacity onPress={() => this.props.handleAdd()}>
                                        <Text style={{ fontSize: 20, margin: 2 }}> + </Text>
                                    </TouchableOpacity>
                                </View>
                            </View>
                        </View>
                    </View>
            </View>
        )
    }
}

const styles = StyleSheet.create({
    shadowEdit: {
        height: 30,
        width: 25,
        borderWidth: 1,
        borderRadius: 2,
        borderColor: '#ddd',
        borderBottomWidth: 0,
        shadowColor: '#000',
        shadowOffset: { width: 0, height: 2 },
        shadowOpacity: 0.8,
        shadowRadius: 2,
        elevation: 1,
        marginLeft: 5,
        marginRight: 5,
        marginTop: 10,
    },
    shadowAdd: {
        height: 30,
        width: 75,
        borderWidth: 1,
        borderRadius: 2,
        borderColor: '#ddd',
        borderBottomWidth: 0,
        shadowColor: '#000',
        shadowOffset: { width: 0, height: 2 },
        shadowOpacity: 0.8,
        shadowRadius: 2,
        elevation: 1,
        marginLeft: 5,
        marginRight: 5,
        marginTop: 10,
        flexDirection: 'row'
    },
    shadowMin: {
        height: 20,
        width: 20,
        borderWidth: 1,
        borderRadius: 2,
        borderColor: '#ddd',
        borderBottomWidth: 0,
        shadowColor: '#000',
        shadowOffset: { width: 0, height: 2 },
        shadowOpacity: 0.8,
        shadowRadius: 2,
        elevation: 1,
        marginLeft: 5,
        marginRight: 5,
        marginTop: 10,
    }
})

const mapStateToProps = (state) => {
    // console.log(state)
    return {
        session_id: state.session_id,
        outlet_id: state.outlet_id,
        order_quantity: state.order_quantity,
        order_total: state.order_total,
        quantity: state.quantity,
    }
}

export default connect(mapStateToProps)(ItemShoping)
