import React from 'react';
import { View, Text, TextInput, StyleSheet, Button, Alert } from 'react-native';
import Axios from 'axios';
import { BASE_URL_RESET_PASSWORD } from '../model/Base_Model';
import ActionType from '../redux/globalActionType';
import { connect } from 'react-redux';
import { TouchableOpacity } from 'react-native-gesture-handler';
import i18n from 'i18n-js';
import Spinner from 'react-native-loading-spinner-overlay';

class ResetPassword extends React.Component {
    constructor(props) {
        super(props);
        this.state = {
            email: '',
            language: 'id',
            spinner:false
        }
    }

    handleResetPassword() {
        this.setState({
            spinner: true,
        })
        let params = {
            'email': this.state.email
        }
        // console.log(this.state.email)
        Axios.post(BASE_URL_RESET_PASSWORD, params).then(res => {
            if (res.status === 200) {
                let resetProps = {
                    email: this.state.email
                }
                this.props.setResetPassword(resetProps);
                this.setState({
                    spinner: false,
                })
                Alert.alert(
                    '',
                    'Email terkirim, mohon dicek'
                    ,
                )
                
                this.props.navigation.navigate('New Password');
            }
        }).catch(error => {
            this.setState({
                spinner: false,
            })
            let response = error.response.data;
            Alert.alert(response.msg);

        })
    }

    render() {
        return (
            <View style={styles.container}>
                 <Spinner
                    visible={this.state.spinner}
                    textContent={'Loading...'}
                    textStyle={styles.spinnerTextStyle}
                />
                <View style={styles.header}>
                    <Text style={{ textAlign: 'center', marginTop: 10, fontSize: 25 }}>{i18n.t('resetPassword')}</Text>
                </View>
                <View style={styles.form}>
                    <View style={styles.field_email}>
                        <View style={{ width: 40, justifyContent: 'center' }}>
                            <Text>Email</Text>
                        </View>
                        <View style={{ flex: 1 }}>
                            <TextInput style={{ height: 40, borderWidth: 1, padding: 5, margin: 10 }}
                                onChangeText={(email) => this.setState({ email })}
                                autoCapitalize="none"
                                value={this.state.email} 
                                keyboardType='email-address'/>
                        </View>
                    </View>
                    <View style={styles.button}>
                        <Button title={i18n.t('submit')} onPress={() => this.handleResetPassword()}></Button>
                    </View>
                    <TouchableOpacity onPress={() => this.handleResetPassword()}>
                        <Text style={{ fontSize: 20, textAlign: 'center', color: 'red' }}>{i18n.t('enterToken')}</Text>
                    </TouchableOpacity>
                </View>
            </View>
        )
    }
}

const styles = StyleSheet.create({

    container: {
        flex: 1,
        backgroundColor: '#ffff'
    },

    header: {
        flex: 0.5,
        margin: 10,
    },

    form: {
        flex: 3,
        margin: 10,
        marginTop: 0,
    },

    field_email: {
        flexDirection: 'row'
    },

    button: {
        height: 40,
        margin: 10,

    }
})

const mapStateToProps = (state) => {
    return {
        email: state.email,
        language: state.language
    }
}

const mapDispatchToProps = (dispacth) => {
    return {
        setResetPassword: (registerProps) => dispacth({
            type: ActionType.SET_RESET_PASSWORD,
            data: {
                email: registerProps.email,
            }
        }),
    }
}

export default connect(mapStateToProps, mapDispatchToProps)(ResetPassword);