import { Notifications } from 'expo';
import { connect } from 'redux';
import * as Permissions from 'expo-permissions';
import ActionType from '../redux/globalActionType';

async function registerForPushNotificationsAsync() {
    const { status } = await Permissions.askAsync(Permissions.NOTIFICATIONS);
    if (status !== 'granted') {
        console.log('No permission');
        return;
    }

    let fb_token = await Notifications.getExpoPushTokenAsync();
    console.log(fb_token);

    let SetPushNotif = {
        fb_token: fb_token
    }
    this.props.setPushProps(SetPushNotif);
}

const mapDispatchToProps = (dispatch) => {
    return {
        setPushNotif: (setPushProps) => dispatch({
            type: ActionType.SET_PUSH_NOTIF,
            data: {
                fb_token:  setPushProps.fb_token
            }
        })
    }
}

const mapStateToProps = (state) => {
    return {
        fb_token: state.fb_token,
    }
}

export default connect(mapStateToProps, mapDispatchToProps)(registerForPushNotificationsAsync);

