import ActionType from './globalActionType';

const globalState = {

    //Set login di set ketika init
    email: '',
    password: '',

    //set register
    full_name:'',
    dob_day:'',
    dob_month:'',
    dob_year:'',
    gender:'',

    //Set device info di set ketika init
    fb_token: '',
    device_id: '',
    os_name: '',
    os_version: '',
    app_version: '',
    session_id:'',


    //set change_profile
    gender_display:'',

    //set registration
    validation_reg: false,

    registration_id:'',
    isEmailverif:false,
    //set position
    position: 'Home',
    pageEmailConfirmation:false,
    proses:'',

    language:'id',
    set_card: false,
    URI:'',
    URI_IDCARD:'',
    id_card64: false,
    img64: false,
    selfie:false,
    idcard:false,

    BASE64_SELFIE:'',
    BASE64_ID:'',

    outlet_id:'',
    name_outlet:'',

    quantity:0,
    orders :0,
    cart_shop:[],

    order_item: [],
    order_quantity: 0,
    order_total: 0,
    
    address:''
}

const rootReducer = (state = globalState, action) => {
    switch (action.type) {
        case ActionType.SET_LOGIN_INFO: {
            return {
                ...state,
                email: action.data.email,
                password: action.data.password,
                session_id: action.data.session_id
            }
        }
        case ActionType.SET_EMAIL_VERIFICATION :{
            return{
                ...state,
                isEmailverif: action.data.isEmailverif,
            }
        }
        case ActionType.SET_PAGE :{
            return{
                ...state,
                pageEmailConfirmation: action.data.pageEmailConfirmation
            }
        }
        case ActionType.SET_DEVICE_INFO: {
            return {
                ...state,

                fb_token: action.data.fb_token,
                device_id: action.data.device_id,
                os_name: action.data.os_name,
                os_version:action.data.os_version,
                app_version: action.data.app_version,
            }
        }
       
        case ActionType.SET_REGISTRATION: {
            return {
                ...state,
                full_name: action.data,
                dob_day: action.dob_day,
                dob_month:action.dob_month,
                dob_year:action.dob_year,
                gender:action.dob_year,
                email: action.data.email,
                validation_reg: action.data.validation_reg,
                registration_id: action.data.registration_id
            }
        }

        case ActionType.SET_CHANGE_LANGUAGE:{
            return{
                ...state,
                language: action.data.language,
            }
        }
        case ActionType.SET_CHANGE_PROFIL:{
            return{
                ...state,
                full_name: action.full_name,
                gender_display: action.gender_display
            }
        }
        case ActionType.SET_RESET_PASSWORD:{
            return{
                ...state,
                email:action.data.email,
            }
        }
        case ActionType.SET_PROSES:{
            return{
                ...state,
                proses:action.data.proses
            }
        }
        case ActionType.SET_CHANGE_EMAIL:{
            return{
                ...state,
                email:action.data.email,
            }
        }
        case ActionType.SET_CHANGE_URI_SELFI:{
            return{
                ...state,
                URI: action.data.URI,
                BASE64_SELFIE: action.data.BASE64_SELFIE
                // id_card64:action.data.id_card64,
                // img64:action.data.img64

            }
        }

        case ActionType.SET_CHANGE_URI_ID:{
            return{
                ...state,
                URI_IDCARD: action.data.URI_IDCARD,
                BASE64_ID: action.data.BASE64_ID
                // id_card64:action.data.id_card64,
                // img64:action.data.img64

            }
        }

        case ActionType.SET_CHANGE_CAMERA:{
            return{
                ...state,
                selfie: action.data.selfie,
                idcard: false
            }
        }
        case ActionType.SET_CHANGE_IMAGE_ID:{
            return{
                ...state,
                idcard: action.data.idcard,
                selfie: false
            }
        }
        case ActionType.SET_CHANGE_IMAGE_SELFI:{
            return{
                ...state,
                selfie: action.data.selfie
            }
        }
        case ActionType.SET_CARD:{
            return{
                ...state,
                set_card: action.data.set_card
                
            }
        }
        case ActionType.SET_CHANGE_OUTLET:{
            return{
                ...state,
                outlet_id: action.data.outlet_id,
                name_outlet: action.data.name_outlet
                
            }
        }
        case ActionType.SET_CHANGE_SHOP:{
            return{
                ...state
            }
        }
        case ActionType.SET_ADDRESS:{
            return{
                ...state,
                address: action.data.address
                
            }
        }
        case ActionType.SET_LOGOUT:{
            return{
                ...state,
                session_id:action.data.session_id,
            }
        }
        case ActionType.ADD_TO_CHART:{

            let addedItem = action.data.item
            let is_exist = state.order_item.find(item => addedItem.id == item.id)
            let order_item = []
            if (is_exist) {
                // update

                updated_data = []
                for (let i = 0; i < state.order_item.length; i++) {
                    const old_data = state.order_item[i];
                    const data = old_data;
                    if (old_data.id == addedItem.id) {
                        update = old_data
                        if (update.quantity == NaN){
                            update.quantity = 1
                        }
                        update.quantity += 1
                        console.log('Update : ' + JSON.stringify(update))
                        data = {...old_data, ...update}
                    }


                    updated_data.push(data)
                }
                order_item = updated_data
            } else {
                // add
                addedItem.quantity = 1
                console.log('Baru : ' + JSON.stringify(addedItem))
                order_item = [...state.order_item, addedItem]
            }

            let quantity = state.order_quantity + 1
            let total = parseInt(state.order_total) + parseInt(addedItem.price)

            return{
                ...state,
                order_item: order_item,
                order_quantity: quantity,
                order_total: total
            }
        }

        case ActionType.REDUCE_QUANTITY_ITEM:{

            let addedItem = action.data.item
            let is_exist = state.order_item.find(item => addedItem.id == item.id)
            let order_item = []
            if (is_exist) {
                // update

                updated_data = []
                for (let i = 0; i < state.order_item.length; i++) {
                    const old_data = state.order_item[i];
                    const data = old_data;
                    if (old_data.id == addedItem.id) {
                        update = old_data
                        if (update.quantity == NaN){
                            update.quantity = 1
                        }
                        update.quantity -= 1
                        console.log('Update : ' + JSON.stringify(update))
                        data = {...old_data, ...update}
                    }


                    updated_data.push(data)
                }
                order_item = updated_data
            } else {
                // add
                addedItem.quantity = 1
                console.log('Baru : ' + JSON.stringify(addedItem))
                order_item = [...state.order_item, addedItem]
            }

            let quantity = state.order_quantity - 1
            let total = parseInt(state.order_total) - parseInt(addedItem.price)

            return{
                ...state,
                order_item: order_item,
                order_quantity: quantity,
                order_total: total
            }
        }

        case ActionType.REMOVE_FROM_CHART:{

            let addedItem = action.data.item
            let is_exist = state.order_item.find(item => addedItem.id == item.id)
            let order_item = []
            if (is_exist) {
                // update

                updated_data = []
                for (let i = 0; i < state.order_item.length; i++) {
                    const old_data = state.order_item[i];
                    const data = old_data;
                    if (old_data.id != addedItem.id) {
                        updated_data.push(data)
                        quantity += data.quantity
                        total += (data.quantity * data.price)
                    }
                }
                
                order_item = updated_data
            }

            return{
                ...state,
                order_item: order_item,
                order_quantity: quantity,
                order_total: total
            }
        }
        
        
        default:
            return state;
    }
}

export default rootReducer;
