import React from 'react';
import { View, Text, StyleSheet, Button, FlatList, Alert } from 'react-native';
import { ScrollView, TouchableOpacity } from 'react-native-gesture-handler';
import { connect } from 'react-redux';
import Axios from 'axios';
import ActionType from '../redux/globalActionType';

class DeliveryAddrees extends React.Component {
    constructor(props) {
        super(props)
        this.state = {
            data: []
        }
    }

    componentDidMount() {
        this.getAddreess()
        console.log(this.props)
    }

    onChangeAddress = data => {
        console.log('DATA FROM CHANGE PROFILE  ' + data);
        this.getAddreess()
    }

    getAddreess() {
        let params = {
            session_id: this.props.session_id,
        }
        // console.log(params)

        Axios.post('https://excelsocrm.ravintoladev.com/crm/v2/member/get_address', params).then(res => {
            const dataAlamat = res.data.data;
            let address = []
            for (let i = 0; i < dataAlamat.length; i++) {
                const element = dataAlamat[i];
                address.push(element)
            }

            this.setState({
                data: address
            })


        }).catch(error => {
            let response = error.response.data;
            Alert.alert(
                '',
                response.msg
            )
        })
    }

    addAdreess() {
        this.props.navigation.navigate('Address Detail', { 'data': 'sample', onChangeAddress: this.onChangeAddress })
    }


    onSave(address) {

        Alert.alert(
            '',
            'Apakah anda akan memilih alamat untuk pengiriman ?',
            [
             
              {text: 'OK', onPress: () => this.props.navigation.navigate('Menu Select')},
            ],
            { cancelable: false }
          )

          let setDataAddress = {
              address : address
          }

          this.props.setAddress(setDataAddress);
    }


    renderItem = ({item})=>{
        return (
            <View style={styles.list_addrees}>
                <TouchableOpacity onPress={()=> this.onSave(item.address)}>
                    <View style={{ margin: 5, }}>
                        <Text style={{ fontWeight: 'bold', fontSize: 20 }}>{item.name}</Text>
                    </View>
                    <Text style={{ margin: 5 }}>
                        {item.address}
                    </Text>
                    <Text style={{ margin: 5 }}>
                        Patokan : {item.description}
                    </Text>
                </TouchableOpacity>
            </View>
        );
    }
    render() {

       
        return (
            <View style={styles.container}>
                <View style={styles.header}>
                    <Text style={{ textAlign: 'center', margin: 20, fontSize: 25, alignSelf: 'center' }}>Delivery Address</Text>
                </View>
                <View style={styles.body}>
                    {/* <ScrollView> */}
                    <View style={styles.btn_addreess}>
                        <Button title="Tambah Alamat" onPress={() => this.addAdreess()}></Button>
                    </View>

                    <FlatList
                        data={this.state.data}
                        renderItem={this.renderItem}
                        keyExtractor={item => item.id}
                    />
                    {/* 
                        <View style={styles.list_addrees}>
                            <View style={{ margin: 5, }}>
                                <Text style={{ fontWeight: 'bold', fontSize: 20 }}>Rumah</Text>
                            </View>
                            <Text style={{ margin: 5 }}>
                                Perkantoran Grenvil Maisonette Blok FB/16,
                                Tanjung Duren, Duri Kepa, Kebon Jeruk, RT.13/RW.9,
                                Duri Kepa, DKI Jakarta, Kota Jakarta Barat,
                                Daerah Khusus Ibukota Jakarta 11510
                            </Text>
                        </View> */}
                    {/* </ScrollView> */}
                </View>
            </View>
        )
    }
}

const styles = StyleSheet.create({
    container: {
        flex: 1,
        backgroundColor: 'white',
    },
    header: {

        flex: 0.5,
    },

    body: {
        flex: 3,
        marginRight: 20,
        marginLeft: 20,
        marginBottom: 20,
        borderWidth: 1,
    },

    btn_addreess: {
        margin: 20,
    },

    list_addrees: {
        flex: 1,
        margin: 20,

        borderWidth: 1,
    }
})

const mapStateToProps = (state) => {
    return {

        session_id: state.session_id,

    }
}

const mapDispatchToProps = (dispacth) => {
    return {
        
        setAddress: (setDataAddress) => dispacth({
            type: ActionType.SET_ADDRESS,
            data: {

                address: setDataAddress.address,
            }
        }),
    }
}

export default connect(mapStateToProps,mapDispatchToProps)(DeliveryAddrees)

