
import * as React from 'react';
import { View, Text, StyleSheet, ScrollView, TouchableOpacity, Alert } from 'react-native';
import { SliderBox } from "react-native-image-slider-box";
import { Card } from 'react-native-shadow-cards';
import { connect } from 'react-redux';
import Axios from 'axios';
import i18n from 'i18n-js';
import _ from 'lodash';


class Home extends React.Component {

  constructor(props) {
    super(props);
    this.state = {
      data_baner: [],
      images: [],
      balance: "",
      point: "",
      account_number: "",
      my_lat: 0,
      my_long: 0,
    }
  }

  componentDidMount() {

    this._renderCarousell()
    this._account()
  }

  //fungsi untuk get current posisi


  clear = () => {
    this.state.search.clear();
  };

  _renderCarousell() {
    Axios.get('https://excelsocrm.ravintoladev.com/cms/v2/list/promotions-carousel').then(respon => {
      // console.log(respon);
      const dataCarousell = respon.data.contents;
      // console.log(dataCarousell);
      // console.log(dataCarousell);
      let imageLink = []

      for (let i = 0; i < dataCarousell.length; i++) {
        const element = dataCarousell[i];
        imageLink.push(element.title_thumb)
      }
      this.setState({
        images: imageLink
      })
    })
  }

  _account() {
    let params = {
      session_id: this.props.session_id
    }

    Axios.post('https://excelsocrm.ravintoladev.com/crm/v2/member/get_profile', params).then(res => {
      const dataCard = res.data
      let point = dataCard.kaspro_point
      let balance = dataCard.kaspro_balance
      let expire = dataCard.expire_date
      let account_number = dataCard.kaspro_account_number

      this.setState({
        point: point,
        balance: balance,
        account_number: account_number,
        expire_date: expire,
      })

      console.log(this.state.expire_date)
    }).catch(error => {
      console.log('ini error ' + error)
    })
  }

  render() {
    return (
      <View style={styles.container}>
        <ScrollView>
          <View style={{ flex: 1 }}>
            <SliderBox
              images={this.state.images}
              // onCurrentImagePressed={index =>console.warn(`image ${index} pressed`)}
              autoplay
              circleLoop
              dotColor='black'
              inactiveDotColor='white'
              sliderBoxHeight={300}
              // currentImageEmitter={index => console.warn(`current pos is: ${index}`)}
              paginationBoxVerticalPadding={20}
              resizeMethod={'resize'}
              resizeMode={'stretch'}
              paginationBoxStyle={{
                position: "absolute",
                bottom: 0,
                padding: 0,
                alignItems: 'center',
                alignSelf: 'center',
                justifyContent: 'center',
                paddingVertical: 10,
                // backgroundColor : ''
              }}
              dotStyle={{
                width: 10,
                height: 10,
                borderRadius: 5,
                marginHorizontal: 0,
                padding: 0,
                margin: 0,
                // backgroundColor: ''
              }}
              ImageComponentStyle={{
                // borderRadius: 5,
                width: '100%',
                // marginTop : 5
              }}
              imageLoadingColor='#c7c7c7'
            />
          </View>
          <View style={styles.content}>
            <View style={styles.card}>
              <Card>
                <View style={{ flexDirection: 'row', justifyContent: 'center' }}>
                  <TouchableOpacity style={styles.buttonDelivery} onPress={() => this.props.navigation.navigate('Delivery Address')}>
                    <Text style={{ textAlign: 'center', color: '#354175', fontWeight: 'bold' }}>{i18n.t('delivery')}</Text>
                  </TouchableOpacity>
                  <TouchableOpacity style={styles.buttonPickup} onPress={() => this.props.navigation.navigate('Pickup Name')}>
                    <Text style={{ textAlign: 'center', color: '#fff', fontWeight: 'bold' }}>{i18n.t('pickup')}</Text>
                  </TouchableOpacity>
                </View>
                <Text style={{ textAlign: 'center', fontSize: 12, }}>
                  {i18n.t('orderInfo')}
                </Text>
                <Text style={{ textAlign: "center", fontSize: 12, top: 5 }}>
                  Excelso Senayan City
            </Text>
                <TouchableOpacity style={styles.submitOrder} activeOpacity={.5} onPress={this.onPress}>
                  <Text style={{ textAlign: 'center', bottom: 5, color: 'white' }}>{i18n.t('orderNow')}</Text>
                </TouchableOpacity>
              </Card>
              {
                this.state.account_number === "" ? (
                  <View style={styles.card}>

                    <Card style={{ padding: 10, margin: 10, alignContent: 'center' }}>
                      <Text style={{ textAlign: "center" }}> Anda belum aktivasi kartu</Text>
                      <Text>
                        {/* {i18n.t('yourCardNumber')} | {this.state.expire_date}{'\n'} */}
                      </Text>
                      <Text style={{ textAlign: "center", fontSize: 40, color: '#c9af6d' }}>
                        {/* {this.state.account_number} */}
                      </Text>
                      <View style={styles.line}></View>
                      <Text style={{ textAlign: 'left', fontWeight: 'bold' }}> {'\n'}
                        {/* {i18n.t('balance')} {this.state.balance}{'\n'} */}
                      </Text>
                      <View style={styles.line}></View>
                      <Text style={{ textAlign: 'left', fontWeight: 'bold' }}>{'\n'}
                        {/* {i18n.t('point')} {this.state.point} */}
                      </Text>
                    </Card>
                  </View>
                ) : (

                    <View style={styles.card}>
                      <Card style={{ padding: 10, margin: 10, alignContent: 'center' }}>
                        <Text>
                          {i18n.t('yourCardNumber')} | {this.state.expire_date}{'\n'}
                        </Text>
                        <Text style={{ textAlign: "center", fontSize: 40, color: '#c9af6d' }}>
                          {this.state.account_number}
                        </Text>
                        <View style={styles.line}></View>
                        <Text style={{ textAlign: 'left', fontWeight: 'bold' }}> {'\n'}
                          {i18n.t('balance')} {this.state.balance}{'\n'}
                        </Text>
                        <View style={styles.line}></View>
                        <Text style={{ textAlign: 'left', fontWeight: 'bold' }}>{'\n'}
                          {i18n.t('point')} {this.state.point}
                        </Text>
                      </Card>
                      {/* <Button title="upgrade premium" onPress={()=>this.props.navigation.navigate("Upgrade Premium")}></Button> */}
                    </View>
                  )
              }
              <View style={{ height: 60 }}></View>
            </View>
          </View>
        </ScrollView>
      </View>
    )
  }
}

const styles = StyleSheet.create({
  container: {
    flex: 1,
    backgroundColor: 'white',
  },

  content: {
    flex: 1,
  },
  card: {
    top: 20,
    alignSelf: 'center',
    flex: 1
  },
  buttonDelivery: {
    marginTop: 10,
    paddingTop: 15,
    paddingBottom: 15,
    marginRight: 0,
    marginLeft: 0,
    backgroundColor: '#cce8f0',
    borderRadius: 10,
    borderWidth: 0,
    borderColor: '#fff',
    width: '50%',
    top: -20,
  },
  buttonPickup: {
    marginTop: 10,
    paddingTop: 15,
    paddingBottom: 15,
    marginRight: 0,
    marginLeft: -30,
    backgroundColor: '#354175',
    borderRadius: 10,
    borderWidth: 0,
    borderColor: '#fff',
    width: '40%',
    top: -20,
  },

  submitOrder: {
    margin: 10,
    paddingTop: 15,
    paddingBottom: 5,
    backgroundColor: '#c9af6d',
    borderRadius: 20,
    borderWidth: 0,
    borderColor: '#fff',
  },

  line: {
    borderBottomColor: '#c9af6d',
    borderBottomWidth: StyleSheet.hairlineWidth,
    alignSelf: 'stretch',
    width: "100%",
    height: 10,
    bottom: 5,
  },
})

const mapStateToProps = (state) => {
  return {

    // login
    email: state.email,
    session_id: state.session_id,
    password: state.password,
    fb_token: state.fb_token,
    device_id: state.device_id,
    os_version: state.os_version,
    os_name: state.os_name,
    app_version: state.app_version,
    isEmailverif: state.isEmailverif,
    proses: state.proses,
    pageEmailConfirmation: state.pageEmailConfirmation,
    language: state.language,
  }
}



export default connect(mapStateToProps)(Home)