import React from 'react';
import { Button, View, Text, StyleSheet, TextInput, Picker, Alert } from 'react-native';
import { ScrollView, TouchableOpacity } from 'react-native-gesture-handler';
import Axios from 'axios';
import { BASE_URL_GET_ENUM, BASE_URL_REGISTER } from '../model/Base_Model';

export default class Register extends React.Component {
    constructor(props) {
        super(props);
        this.state = ({
            email: "wahyu.rav@mailinator.com",
            no_hp: "083872961997",
            password: "wahyu123",
            full_name: "wahyu adjie prasetyo",
            gender: "1",
            dob_year: "1997",
            dob_month: "08",
            dob_day: "25",
            profession: "",
            domicilie: "",
            list_gender: [],
            list_domicilie: [],
            list_profesion: [],
            list_dob: [],
            selected_item: [],
            date:[]
        })
        // this.load_data();
    }

    componentDidMount() {

        this.load_data();
    }

    load_data() {


        return Axios.get(BASE_URL_GET_ENUM).then(res => {
            const data_enum = res.data;
            const list_gender = data_enum.gender

            const list_profesion = data_enum.profession
            const list_domicilie = data_enum.domicile

            this.setState({

                list_gender: list_gender,
                list_profesion: list_profesion,
                list_domicilie: list_domicilie,
            })

            console.log(this.state.list_gender);
            console.log(this.state.list_domicilie);
        })
    }


    handleReg() {

        let parameter = {
            "email": this.state.email,
            "password": this.state.password,
            "mobile_phone": this.state.no_hp,
            "name": this.state.full_name,
            "gender": this.state.gender,
            "dob_year": this.state.dob_year,
            "dob_month": this.state.dob_month,
            "dob_day": this.state.dob_day,
            "profession": this.state.profession,
            "domicile": this.state.domicilie,
        }

        console.log(parameter);
        Axios.post(BASE_URL_REGISTER, parameter).then(res => {
            console.log('sukses');
        }).catch(error => {
            console.log(error);
        })
    }

    render() {
        return (
            <View style={styles.container}>
                <ScrollView>
                    <View style={{ marginRight: 10, marginLeft: 10 }}>
                        <Text style={{ top: 5 }}>Email</Text>
                    </View>
                    <View style={{ margin: 10 }}>
                        <TextInput
                            style={{ height: 40, borderColor: 'gray', borderWidth: 1 }}
                            onChangeText={(email) => this.setState({ email })}
                            value={this.state.email}
                        />
                    </View>
                    <View style={{ marginRight: 10, marginLeft: 10 }}>
                        <Text style={{ top: 5 }}>No handphone</Text>
                    </View>
                    <View style={{ margin: 10 }}>
                        <TextInput
                            style={{ height: 40, borderColor: 'gray', borderWidth: 1 }}
                            onChangeText={no_hp => this.setState({ no_hp })}
                            value={this.state.no_hp}
                        />
                    </View>
                    <View style={{ marginRight: 10, marginLeft: 10 }}>
                        <Text style={{ top: 5 }}>Password</Text>
                    </View>
                    <View style={{ margin: 10 }}>
                        <TextInput
                            style={{ height: 40, borderColor: 'gray', borderWidth: 1 }}
                            onChangeText={password => this.setState({ password })}
                            value={this.state.password}
                        />
                    </View>
                    <View style={{ marginRight: 10, marginLeft: 10 }}>
                        <Text style={{ top: 5 }}>Nama lengkap</Text>
                    </View>
                    <View style={{ margin: 10 }}>
                        <TextInput
                            style={{ height: 40, borderColor: 'gray', borderWidth: 1 }}
                            onChangeText={full_name => this.setState({ full_name })}
                            value={this.state.full_name}
                        />
                    </View>
                    <View style={{ marginRight: 10, marginLeft: 10 }}>
                        <Text style={{ top: 5 }}>Jenis Kelamin</Text>
                    </View>
                    <View style={{ margin: 10 }}>
                        {/* { Object.entries(this.state.list_gender).map((t,k) => <Text key={k}>{t[0]}.{t[1]}</Text>)} */}
                        <Picker selectedValue={this.state.gender} onValueChange={(itemValue, itemIndex) => this.setState({ gender: itemValue })}>
                            {
                                Object.entries(this.state.list_gender).map((item, key) =>
                                    <Picker.Item label={item[1]} key={key} value={item[0]}>
                                    </Picker.Item>
                                )
                            }
                        </Picker>
                    </View>
                    <View style={{ marginRight: 10, marginLeft: 10, marginBottom: 10 }}>
                        <Text style={{ top: 5, bottom: 5 }}>Tanggal Lahir</Text>
                    </View>
                    <View style={{ margin: 10 }}>
                        <TextInput
                            onChangeText={dob_day => this.setState({ dob_day })}
                            value={this.state.dob_day}
                            style={{ height: 40, borderColor: 'gray', borderWidth: 1 }}>
                        </TextInput>
                    </View>
                    <View style={{ marginRight: 10, marginLeft: 10 }}>
                        <Text style={{ top: 5 }}>Profesi</Text>
                    </View>
                    <View style={{ margin: 10 }}>
                        <Picker selectedValue={this.state.profession} onValueChange={(itemValue, itemIndex) => this.setState({ profession: itemValue })}>
                            {
                                this.state.list_profesion.map((item) => {
                                    return (
                                        <Picker.Item label={item.name} value={item.name} key={item.name} />
                                    );
                                })
                            }
                        </Picker>
                    </View>
                    <View style={{ marginRight: 10, marginLeft: 10 }}>
                        <Text style={{ top: 5 }}>Area Domisili</Text>
                    </View>
                    <View style={{ margin: 10 }}>
                        <Picker selectedValue={this.state.domicilie} onValueChange={(itemValue, itemIndex) => this.setState({ domicilie: itemValue })}>
                            {
                                this.state.list_domicilie.map((item) => {
                                    return (
                                        <Picker.Item label={item.name} value={item.name} key={item.name}></Picker.Item>
                                    )
                                })
                            }
                        </Picker>
                    </View>
                    <View style={{ marginRight: 10, marginLeft: 10, marginBottom: 15 }}>
                        <Button
                            title="Register"
                            onPress={() => this.handleReg()}
                        />
                    </View>
                </ScrollView>
            </View>
        )
    }
}

const styles = StyleSheet.create({

    container: {
        flex: 1,
        backgroundColor: 'white'

    }
})
