import React from 'react';
import { View, Text, TextInput, StyleSheet, Button, TouchableOpacity, ScrollView, FlatList, Image } from 'react-native';
import { connect } from 'react-redux'
// import { CheckBox } from 'react-native-elements'
import CheckBox from 'react-native-check-box'
import { Card } from 'react-native-shadow-cards'
import { Entypo, Ionicons, MaterialCommunityIcons, MaterialIcons, AntDesign, FontAwesome } from '@expo/vector-icons'
import i18n from 'i18n-js';
import CurrencyFormat from 'react-currency-format';
import Axios from 'axios'

class ShoppingCart extends React.Component {
    constructor(props) {
        super(props)
        this.state = {
            kasproBalance: '',
            kasproPoint: '',
            checkedBalance: false,
            checkedPoint: false,
            checkedBalancePoint: false,
            balanceused: 0,
            pointsused: 0,
            ongkir: 0,
            diskon: 0,
            isDelivery: false,
            isPickUp: false
            // dummyBalance : 155000,
            // dummyPoint : 20000
        }
    }

    minusQty(item, index) {

        const listMenu = [...this.state.listMenu]
        let hasil = [];
        if (listMenu[index].qty !== 0) {
            listMenu[index].qty -= 1
            this.setState({
                listMenu
            })

            // hasil.push(listMenu[index].qty);
            // console.log("INI HASILNYA : " + JSON.stringify(hasil))
        }

    }
    plusQty(item, index) {

        this.setState({
            shopingCart: item
        })
        const listMenu = [...this.state.listMenu]
        listMenu[index].qty += 1

        this.setState({
            listMenu,
        })
    }

    checkChangeTrans(val) {
        console.log('hai lg di sini')
        console.log(val)
        if (val == 'delivery') {
            this.setState({
                isDelivery: true,
                isPickUp: false
            })
            console.log('ini delivery')
        } else {
            this.setState({
                isPickUp: true,
                isDelivery: false
            })
            console.log('ini pickup')
        }
    }
    handleAdd(item, index) {
        const order_item = {
          id: item.id,
          name: item.name,
          price: item.price,
          image: item.image
        }
    
        this.props.addToChart(order_item)
    
        const list_order_item = this.props.order_item;
        let quantity = 0
        for (let i = 0; i < list_order_item.length; i++) {
          const row = list_order_item[i];
          if (row.id == item.id) {
            quantity = row.quantity
          }
        }
    
        const listMenu = [...this.state.listMenu]
        listMenu[index].qty = quantity
        this.setState({
          listMenu
        })
      }
    
      handleMin(item, index) {
        const order_item = {
          id: item.id,
          name: item.name,
          price: item.price,
    
        }
    
        this.props.reduceQuantityItem(order_item)
        const list_order_item = this.props.order_item;
        let quantity = 0
        if (quantity != 0) {
          quantity = quantity - 1
          for (let i = 0; i < list_order_item.length; i++) {
            const row = list_order_item[i];
            if (row.id == item.id) {
              quantity = row.quantity
            }
          }
          const listMenu = [...this.state.listMenu]
          listMenu[index].qty = quantity
          this.setState({
            listMenu
          })
        }
      }

    checkedSelection(val) {
        // console.log(val)
        if (val == 'balance') {
            this.setState({
                checkedBalance: true,
                checkedPoint: false,
                checkedBalancePoint: false,
                balanceused: this.props.order_total,
                pointsused: 0
            })
        } else if (val == 'point') {
            this.setState({
                checkedBalance: false,
                checkedPoint: true,
                checkedBalancePoint: false,
                pointsused: this.props.order_total,
                balanceused: 0
            })
        } else {
            this.setState({
                checkedBalance: false,
                checkedPoint: false,
                checkedBalancePoint: true,
                // balanceused : this.props.order_total - this.state.dummyPoint,
                // pointsused : this.props.order_total,
            })
            if (this.state.kasproPoint - this.props.order_total >= -1) {
                this.setState({
                    pointsused: this.props.order_total
                })
            } else {
                this.setState({
                    balanceused: this.props.order_total - this.state.kasproPoint,
                    pointsused: this.state.kasproPoint
                })
            }




        }
    }

    componentDidMount() {
        this.getBalance()
    }

    getBalance() {
        let params = {
            session_id: this.props.session_id
        }

        Axios.post('https://excelsocrm.ravintoladev.com/crm/v2/member/get_profile', params).then(res => {
            // console.log(res.data)
            const { kaspro_balance, kaspro_point } = res.data
            // console.log(kaspro_balance,kaspro_point)
            this.setState({
                kasproBalance: kaspro_balance,
                kasproPoint: kaspro_point
            })

            // console.log(this.state.kasproBalance, this.state.kasproPoint)
        }).catch(error => {
            console.log('ini error ' + error)
        })
    }

    render() {
        return (
            <ScrollView style={styles.container}>
                <View style={{ flexDirection: 'row', justifyContent: 'center' }}>
                    <TouchableOpacity style={styles.buttonDelivery} onPress={() => this.checkChangeTrans('delivery')}>
                        <Text style={{ textAlign: 'center', color: '#354175', fontWeight: 'bold' }}>{i18n.t('delivery')}</Text>
                    </TouchableOpacity>
                    <TouchableOpacity style={styles.buttonPickup} onPress={() => this.checkChangeTrans('pickup')}>
                        <Text style={{ textAlign: 'center', color: '#fff', fontWeight: 'bold' }}>{i18n.t('pickup')}</Text>
                    </TouchableOpacity>
                </View>
                <View style={{ alignItems: 'center' }}>
                    {
                        this.state.isDelivery == true ? (
                            <Card style={{ margin: 5, padding: 10 }}>
                                <Text style={{ textAlign: 'center' }}> Ambil pesanan kamu di</Text>
                                <Text style={{ textAlign: 'center' }}>{this.props.address}</Text>
                            </Card>



                        ) : (
                                <Card style={{ margin: 5, padding: 10 }}>
                                    <Text style={{ textAlign: 'center' }}> Pesanan kamu dikirim ke</Text>
                                    <Text style={{ textAlign: 'center' }}>{this.props.address}</Text>
                                </Card>
                            )
                    }
                </View>
                <View style={styles.header}>
                    <Text style={{ textAlign: 'center', fontSize: 15 }}>YOUR ORDER(S)</Text>
                    <TouchableOpacity onPress={() => this.props.navigation.goBack()}>
                        <Text style={{ textAlign: 'center', fontSize: 15, color: '#ccb46c' }}>+ ADD MORE</Text>
                    </TouchableOpacity>
                </View>
                <View style={styles.order}>

                    {this.props.order_item.map((item, index) => {
                        return (
                            <View style={{ flex: 1, margin: 10 }} key={index}>
                                <View style={{ flexDirection: 'row' }}>
                                    <View >
                                        <Image source={{ uri: item.image }} style={{ height: 100, width: 100, borderRadius: 5, top: 5 }}></Image>
                                    </View>
                                    <View >
                                        <Text style={{ fontSize: 20, margin: 5, marginRight: 10, fontWeight: 'bold' }}>{item.name}</Text>
                                        <Text style={{ fontSize: 15, margin: 5, marginRight: 10 }}>Rp. {item.price}</Text>
                                        <View style={{ flexDirection: 'row', flex: 1 }}>
                                            <View style={styles.shadowEdit}></View>
                                            <View style={styles.shadowAdd}>
                                                <TouchableOpacity onPress={() => this.props.handleMin(item,index)}>
                                                    <Text style={{ fontSize: 20, margin: 2 }}> - </Text>
                                                </TouchableOpacity>
                                                <TextInput
                                                    style={{ height: 25, padding: 2, textAlign: 'center', margin: 2 }}
                                                    autoCapitalize="none">
                                                    {item.quantity}
                                                </TextInput>
                                                <TouchableOpacity onPress={() => this.props.handleAdd(item,index)}>
                                                    <Text style={{ fontSize: 20, margin: 2 }}> + </Text>
                                                </TouchableOpacity>
                                            </View>
                                        </View>
                                    </View>
                                </View>
                            </View>

                        )
                    })}

                </View>
                <View style={styles.voucher}>
                    <TouchableOpacity>
                        <Text style={{ color: '#ccb46c' }}>+ ADD VOUCHER</Text>
                    </TouchableOpacity>
                </View>
                <View style={styles.payment}>
                    <Text>PAYMENT METHODS</Text>
                </View>
                <View style={{ alignItems: 'center' }}>
                    {
                        this.state.kasproBalance < this.props.order_total ? (
                            <Card style={{ margin: 5, padding: 10, backgroundColor: 'gray' }}>
                                <View style={{ flexDirection: 'row', justifyContent: 'space-between', alignItems: 'center' }}>
                                    <View>
                                        <Text>EXCELSO BALANCE</Text>
                                    </View>
                                    <View style={{ paddingRight: 10 }}>
                                        <FontAwesome name='circle-o' size={30} color={'#ccb46c'} />
                                    </View>
                                </View>
                            </Card>
                        ) : (
                                <TouchableOpacity onPress={() => {
                                    this.checkedSelection('balance')
                                }}>
                                    <Card style={{ margin: 5, padding: 10 }}>
                                        <View style={{ flexDirection: 'row', justifyContent: 'space-between', alignItems: 'center' }}>
                                            <View>
                                                <Text>EXCELSO BALANCE</Text>
                                            </View>
                                            <View style={{ paddingRight: 10 }}>
                                                <CheckBox
                                                    onClick={() => {
                                                        this.checkedSelection('balance')
                                                    }}
                                                    isChecked={this.state.checkedBalance}
                                                    checkedImage={<FontAwesome name='check-circle' size={30} color={'#ccb46c'} />}
                                                    unCheckedImage={<FontAwesome name='circle-o' size={30} color={'#ccb46c'} />}
                                                />
                                            </View>
                                        </View>
                                    </Card>
                                </TouchableOpacity>
                            )
                    }
                </View>
                <View style={{ alignItems: 'center' }}>
                    {
                        this.state.kasproPoint < this.props.order_total ? (
                            <Card style={{ margin: 5, padding: 10, backgroundColor: 'gray' }}>
                                <View style={{ flexDirection: 'row', justifyContent: 'space-between', alignItems: 'center' }}>
                                    <View>
                                        <Text>EXCELSO POINTS</Text>
                                    </View>
                                    <View style={{ paddingRight: 10 }}>
                                        <FontAwesome name='circle-o' size={30} color={'#ccb46c'} />
                                    </View>
                                </View>
                            </Card>
                        ) : (

                                <TouchableOpacity onPress={() => {
                                    this.checkedSelection('point')
                                }}>
                                    <Card style={{ margin: 5, padding: 10 }}>
                                        <View style={{ flexDirection: 'row', justifyContent: 'space-between', alignItems: 'center' }}>
                                            <View>
                                                <Text>EXCELSO POINTS</Text>
                                            </View>
                                            <View style={{ paddingRight: 10 }}>
                                                <CheckBox
                                                    onClick={() => {
                                                        this.checkedSelection('point')
                                                    }}
                                                    isChecked={this.state.checkedPoint}
                                                    checkedImage={<FontAwesome name='check-circle' size={30} color={'#ccb46c'} />}
                                                    unCheckedImage={<FontAwesome name='circle-o' size={30} color={'#ccb46c'} />}
                                                />
                                            </View>
                                        </View>
                                    </Card>
                                </TouchableOpacity>
                            )
                    }
                </View>
                <View style={{ alignItems: 'center' }}>
                    {
                        this.state.kasproPoint + this.state.kasproBalance >= this.props.order_total && this.state.kasproBalance != 0 && this.state.kasproPoint != 0 ? (
                            <TouchableOpacity onPress={() => {
                                this.checkedSelection('balancepoint')
                            }}>
                                <Card style={{ margin: 5, padding: 10 }}>
                                    <View style={{ flexDirection: 'row', justifyContent: 'space-between', alignItems: 'center' }}>
                                        <View>
                                            <Text>EXCELSO BALANCE + POINTS</Text>
                                        </View>
                                        <View style={{ paddingRight: 10 }}>
                                            <CheckBox
                                                onClick={() => {
                                                    this.checkedSelection('balancepoint')
                                                }}
                                                isChecked={this.state.checkedBalancePoint}
                                                checkedImage={<FontAwesome name='check-circle' size={30} color={'#ccb46c'} />}
                                                unCheckedImage={<FontAwesome name='circle-o' size={30} color={'#ccb46c'} />}
                                            />
                                        </View>
                                    </View>
                                </Card>
                            </TouchableOpacity>
                        ) : (
                                <Card style={{ margin: 5, padding: 10, backgroundColor: 'gray' }}>
                                    <View style={{ flexDirection: 'row', justifyContent: 'space-between', alignItems: 'center' }}>
                                        <View>
                                            <Text>EXCELSO BALANCE + POINTS</Text>
                                        </View>
                                        <View style={{ paddingRight: 10 }}>
                                            <FontAwesome name='circle-o' size={30} color={'#ccb46c'} />
                                        </View>
                                    </View>
                                </Card>

                            )
                    }
                </View>
                <View style={{ alignItems: 'center', }}>
                    <Card style={{ margin: 5, padding: 10 }}>
                        <View style={{ flexDirection: 'row', justifyContent: 'space-between', marginBottom: 5 }}>
                            <View>
                                <Text>Your Balance</Text>
                                <Text>Your Points</Text>
                            </View>
                            <View style={{ paddingRight: 30, alignItems: 'flex-end' }}>
                                <Text>{this.state.kasproBalance}</Text>
                                <Text>{this.state.kasproPoint}</Text>
                            </View>
                        </View>
                        <View style={{ flexDirection: 'row', justifyContent: 'space-between', borderTopWidth: 1 }}>
                            <View style={{ marginTop: 5 }}>
                                <Text>Your Balance Used</Text>
                                <Text>Your Points Used</Text>
                            </View>
                            <View style={{ paddingRight: 30, marginTop: 5, alignItems: 'flex-end' }}>
                                <Text>- {this.state.balanceused}</Text>
                                <Text>- {this.state.pointsused}</Text>
                            </View>
                        </View>
                    </Card>
                </View>

                <View style={styles.paymentDetails}>
                    <Text>PAYMENT DETAILS</Text>
                </View>
                <View style={{ margin: 10 }}>
                    {/* <Text style={{ paddingLeft: 20, paddingTop: 15, color: 'gray' }}>Detail Pembayaran</Text> */}
                    <View style={{ flexDirection: 'row', marginTop: 10, justifyContent: 'space-between' }}>
                        <View>
                            <Text style={{ paddingLeft: 20, paddingTop: 15, color: 'gray' }}>Harga</Text>
                        </View>
                        <View style={{ paddingRight: 30, paddingTop: 10, alignItems: 'flex-end' }}>
                            <Text style={{ color: 'gray' }}>{this.props.order_total}</Text>
                        </View>
                    </View>
                    <View style={{ flexDirection: 'row', marginTop: 10, justifyContent: 'space-between' }}>
                        <View>
                            <Text style={{ paddingLeft: 20, paddingTop: 10, color: 'gray' }}>Ongkos Kirim</Text>
                        </View>
                        <View style={{ paddingRight: 30, paddingTop: 10, alignItems: 'flex-end' }}>
                            <Text style={{ color: 'gray' }}>{this.state.ongkir}</Text>
                        </View>
                    </View>
                    <View style={{ flexDirection: 'row', marginTop: 10, justifyContent: 'space-between' }}>
                        <View>
                            <Text style={{ paddingLeft: 20, paddingTop: 10, color: 'gray' }}>Diskon</Text>
                        </View>
                        <View style={{ paddingRight: 30, paddingTop: 10, alignItems: 'flex-end' }}>
                            <Text style={{ color: 'gray' }}>{this.state.diskon}</Text>
                        </View>
                    </View>
                    <View style={{ flexDirection: 'row', marginTop: 10, justifyContent: 'space-between' }}>
                        <View style={{ marginTop: 15, paddingLeft: 20, paddingTop: 10 }}>
                            <Text style={{ fontSize: 35, color: '#ccb46c' }}>Total</Text>
                        </View>
                        <View style={{ marginTop: 15, paddingRight: 30, paddingTop: 10, alignItems: 'flex-end' }}>
                            <Text style={{ fontSize: 35, color: '#ccb46c' }}>{this.props.order_total}</Text>
                        </View>
                    </View>
                    <View style={{ flexDirection: 'row', marginTop: 10, justifyContent: 'space-between' }}>
                        <View>
                            <Text style={{ paddingLeft: 20, paddingTop: 10, color: 'gray' }}>Tujuan</Text>
                        </View>
                        <View style={{ paddingRight: 30, paddingTop: 10, alignItems: 'flex-end' }}>
                            <Text style={{ color: '#ccb46c' }}>{this.props.address}</Text>
                        </View>
                    </View>
                    <View style={{ margin: 20, }}>
                        <Button title='Checkout' color='#ccb46c' />
                    </View>
                </View>
            </ScrollView>
        )
    }
}


const styles = StyleSheet.create({

    container: {
        flex: 1,
        backgroundColor: '#ffff'
    },

    header: {
        flex: 0.2,
        margin: 10,
        padding: 20,
        borderBottomWidth: 1,
        borderTopWidth: 1,
        flexDirection: 'row',
        alignItems: 'center',
        justifyContent: 'space-between'
    },

    order: {
        flex: 1,
        margin: 10,
        backgroundColor: '#fff'
    },

    payment: {
        flex: 1,
        margin: 10,
        padding: 20,
        borderTopWidth: 1,
        borderBottomWidth: 1,
        // backgroundColor: 'lightblue'
    },

    voucher: {
        flex: 1,
        margin: 10,
        padding: 20,
        borderTopWidth: 1,
        borderBottomWidth: 1,
        // backgroundColor: 'lightblue'
    },

    paymentDetails: {
        flex: 1,
        margin: 10,
        padding: 20,
        borderTopWidth: 1,
        borderBottomWidth: 1,
        // backgroundColor: 'lightblue'
    },
    buttonDelivery: {
        marginTop: 10,
        paddingTop: 15,
        paddingBottom: 15,
        marginRight: 0,
        marginLeft: 0,
        backgroundColor: '#cce8f0',
        borderRadius: 10,
        borderWidth: 0,
        borderColor: '#fff',
        width: '50%',
        // top: -20,
    },
    buttonPickup: {
        marginTop: 10,
        paddingTop: 15,
        paddingBottom: 15,
        marginRight: 0,
        marginLeft: -50,
        backgroundColor: '#354175',
        borderRadius: 10,
        borderWidth: 0,
        borderColor: '#fff',
        width: '40%',
        // top: -20,
    },

    shadowEdit: {
        height: 30,
        width: 25,
        borderWidth: 1,
        borderRadius: 2,
        borderColor: '#ddd',
        borderBottomWidth: 0,
        shadowColor: '#000',
        shadowOffset: { width: 0, height: 2 },
        shadowOpacity: 0.8,
        shadowRadius: 2,
        elevation: 1,
        marginLeft: 5,
        marginRight: 5,
        marginTop: 10,
    },
    shadowAdd: {
        height: 30,
        width: 75,
        borderWidth: 1,
        borderRadius: 2,
        borderColor: '#ddd',
        borderBottomWidth: 0,
        shadowColor: '#000',
        shadowOffset: { width: 0, height: 2 },
        shadowOpacity: 0.8,
        shadowRadius: 2,
        elevation: 1,
        marginLeft: 5,
        marginRight: 5,
        marginTop: 10,
        flexDirection: 'row'
    },
    shadowMin: {
        height: 20,
        width: 20,
        borderWidth: 1,
        borderRadius: 2,
        borderColor: '#ddd',
        borderBottomWidth: 0,
        shadowColor: '#000',
        shadowOffset: { width: 0, height: 2 },
        shadowOpacity: 0.8,
        shadowRadius: 2,
        elevation: 1,
        marginLeft: 5,
        marginRight: 5,
        marginTop: 10,
    }


})


const mapDispatchToProps = (dispacth) => {
    return {
      //REDUCE QUANTITY ITEM
      reduceQuantityItem: (item) => dispacth({
        type: ActionType.REDUCE_QUANTITY_ITEM,
        data: {
          item: item
        }
      }),
    }
  }

const mapStateToProps = (state) => {
    console.log(state)
    return {
        session_id: state.session_id,
        outlet_id: state.outlet_id,
        order_quantity: state.order_quantity,
        order_total: state.order_total,
        order_item: state.order_item,
        quantity: state.quantity,
        address: state.address
    }
}


export default connect(mapStateToProps,mapDispatchToProps)(ShoppingCart)
