import React from 'react'
import { View, Text, TextInput, StyleSheet, ScrollView, Alert, TouchableOpacity, Button } from 'react-native'
import { Card } from 'react-native-shadow-cards'
import { connect } from 'react-redux'
import Axios from 'axios'

class TransactionDetail extends React.Component {
    constructor(props) {
        super(props)
        this.state = {
            transDetail: [],
            transDate: '',
            transDiscount: '',
            transId: '',
            transTax: '',
            transTotal: ''
        }
    }

    componentDidMount() {
        this.getDetailTrans()
    }

    getDetailTrans() {
        let params = {
            session_id: this.props.session_id,
            transaction_id: this.props.route.params.idTrans
        }
        Axios.post('https://excelsocrm.ravintoladev.com/crm/v2/transaction/detail', params).then(res => {
            let data = res.data
            console.log(data)
            this.setState({
                transId: data.trans_id,
                transDate: data.trans_date,
                transTotal: data.trans_total,
                transDetail: data.transaction_detail
            })
            // console.log(this.state.history_list)
        }).catch(error => {
            let response = error.response.data;
            Alert.alert(response.msg);
        })
    }

    render() {
        return (
            <View style={styles.container}>
                <View style={styles.header}>
                    <Text style={{ textAlign: 'center', margin: 20, fontSize: 25, alignSelf: 'center' }}>Transaction Detail</Text>
                </View>
                <View style={styles.body}>
                    <Card style={{ padding: 10, margin: 10, alignContent: 'center' }}>
                        <Text> Jenis Transaksi : {this.state.transId}</Text>
                        <Text> Tanggal : {this.state.transDate}</Text>
                        <Text> Total : {this.state.transTotal}</Text>
                        <Text> Detail : {this.state.transDetail}</Text>
                        <Button title="OK" onPress={() => this.props.navigation.goBack()}/>
                    </Card>

                </View>
            </View>
        )
    }
}

const styles = StyleSheet.create({
    container: {
        flex: 1,
        backgroundColor: 'white',
    },
    header: {

        flex: 0.5,

    },

    body: {
        flex: 3,
        margin: 5,

    },
    list_detail_order: {
        flex: 1,
        margin: 20,
        borderWidth: 1,
    }
})

const mapStateToProps = (state) => {
    return {

        session_id: state.session_id,

    }
}

export default connect(mapStateToProps)(TransactionDetail)