import React from 'react';
import { View, Text, TextInput, StyleSheet, ScrollView, Alert, TouchableOpacity, Image } from 'react-native';
import { connect } from 'react-redux';
import Axios from 'axios';
import session from '../function/session';
import HTML from 'react-native-render-html';
import { WebView } from 'react-native-webview';
import ActionType from '../redux/globalActionType';
import moment from 'moment';
import { Button } from 'react-native-elements';

class RewardDetail extends React.Component {
    constructor(props) {
        super(props)
        this.state = {
            image: '',
            title: '',
            subtitle: '',
            content: "",
            expire: '',
            code: '',
            used: '',
            dateNow: '',
            value: '',
            cur_time: '',
            exp_time: '',
        }
    }

    componentDidMount() {
        this.detailReward()
        this._unsubscribe = this.props.navigation.addListener('focus', () => {
            this.detailReward()
        });
    }

    componentWillUnmount() {
        this._unsubscribe()
    }

    detailReward() {

        let params = {
            session_id: this.props.session_id,
            reward_id: this.props.route.params.rewardId
        }
        Axios.post('https://excelsocrm.ravintoladev.com/crm/v2/reward/get_detail', params).then(res => {


            let expire_date = moment(res.data.reward.expire_time).format('DD MMMM YYYY')
            let exp_time = new Date(res.data.reward.expire_time)
            exp_time.setHours(0, 0, 0, 0);
            let cur_time = new Date()
            cur_time.setHours(0, 0, 0, 0);

            this.setState({
                image: res.data.reward.reward.content_image,
                title: res.data.reward.reward.title,
                subtitle: res.data.reward.reward.subtitle,
                content: res.data.reward.reward.content,
                expire: expire_date,
                code: res.data.reward.verification_number,
                used: res.data.reward.used,
                value: res.data.reward.reward,
                cur_time: cur_time,
                exp_time: exp_time

            })

        }).catch(error => {
            const { navigation } = this.props
            let response = error.response.data
            session(response, navigation)
            Alert.alert(response.msg);
        })
    }


    useVoucher() {
        let voucherProps = {
            value_voucher: this.state.value,
            voucher: this.state.value
        }

        this.props.setVoucher(voucherProps);
        this.props.navigation.navigate('Home', { screen: 'MENU' })

    }

    useDVoucher() {
        this.props.navigation.navigate('Order Detail')
    }


    render() {
        return (
            <View style={styles.container}>
                <ScrollView>
                    <View style={styles.images}>
                        <Image style={{ height: 250 }} source={this.state.image ? { uri: this.state.image } : null} />
                        <View style={styles.voucher_code}>
                            <Text style={styles.text_voucher}>Voucher Code : </Text>
                            <Text style={styles.text_c_voucher}>{this.state.code}</Text>
                        </View>
                        <View style={styles.expire_time}>
                            <Text style={styles.text_expire}>Expire Time : </Text>
                            <Text style={styles.text_c_expire}>{this.state.expire}</Text>
                        </View>

                    </View>
                    <View style={styles.content}>
                        {this.state.cur_time >= this.state.exp_time ? (<Button
                            style={{ margin: 5 }}
                            title="EXPIRED"
                            onPress={() => console.log('inin')}
                            buttonStyle={{ height: 50, backgroundColor: 'red' }}
                        />)
                            : this.state.used == 0 ? (
                                <Button
                                    style={{ margin: 5 }}
                                    title="USE VOUCHER"
                                    onPress={() => this.useVoucher()}
                                    buttonStyle={{ height: 50, backgroundColor: '#2ead28' }}
                                />
                            ) : (
                                    <Button
                                        style={{ margin: 5 }}
                                        title="USED"
                                        onPress={() => this.useDVoucher()}
                                        buttonStyle={{ height: 50, backgroundColor: '#2ead28' }}
                                    />
                                )}

                    </View>
                    <View style={styles.content}>
                        <View style={{ margin: 10 }}>
                            <HTML html={this.state.content} />
                        </View>
                    </View>
                </ScrollView>
            </View>
        )
    }
}

const styles = StyleSheet.create({

    container: {
        flex: 1,
        backgroundColor: 'white',
    },
    body: {
        flex: 1,
        backgroundColor: 'red'
    },

    voucher_code: {

        height: 70,
        marginLeft: 20,
        marginRight: 20,
        backgroundColor: '#01919c',
        flex: 1,
        marginTop:-140

    },

    expire_time: {

        flex: 1,
        marginLeft: 20,
        marginRight: 20,
        height: 70,
        backgroundColor: 'black',
    },

    text_voucher: {
        fontSize: 15,
        marginLeft: 10,
        top: 5,
        color: 'white'
    },

    text_c_voucher: {
        textAlign: 'center',
        fontWeight: 'bold',
        fontSize: 30,
        top: 5,
        color: 'white'
    },

    text_expire: {
        fontSize: 15,
        marginLeft: 10,
        top: 5,
        color: 'white'
    },

    text_c_expire: {
        textAlign: 'center',
        fontWeight: 'bold',
        fontSize: 30,
        top: 5,
        color: 'white'
    },

    content: {

        flex: 1,
    },
    button: {
        flex: 1,
        height: 60,
        backgroundColor: '#2ead28',
        borderRadius: 5,
    },
    images: {
        flex: 1,
    }
})


const mapDispatchToProps = (dispacth) => {
    return {

        setVoucher: (voucherProps) => dispacth({
            type: ActionType.SET_VOUCHER,
            data: {

                voucher: voucherProps.voucher,
                value_voucher: voucherProps.value_voucher,

            }
        }),
    }
}

const mapStateToProps = (state) => {
    return {

        session_id: state.session_id,
        lat: state.lat,
        long: state.long,

    }
}

export default connect(mapStateToProps, mapDispatchToProps)(RewardDetail);
