import React from 'react';
import { View, Text, Image, StyleSheet, ScrollView, Alert, TouchableOpacity } from 'react-native';
import { Card } from 'react-native-shadow-cards'
import { connect } from 'react-redux';
import Axios from 'axios';
import moment from 'moment'

class RewardsList extends React.Component {
    constructor(props) {
        super(props)
        this.state = {
            rewardsList: []
        }
    }

    componentDidMount() {
        this.getRewardsList()
        this._unsubscribe = this.props.navigation.addListener('focus', () => {
            this.getRewardsList()

        });
    }

    componentWillUnmount() {
        this._unsubscribe()
    }

    getRewardsList() {
        let params = {
            session_id: this.props.session_id
        }
        Axios.post('https://excelsocrm.ravintoladev.com/crm/v2/reward/get_list', params).then(res => {
            let data = res.data.rewards
            // console.log(data)
            data.map((item,key) => {
                // console.log(item.expire_time)
                item.expire_time = moment(item.expire_time).format("DD MMMM YYYY")  
            })
            // console.log(data)
            this.setState({
                rewardsList: data
            })

        }).catch(error => {
            let response = error.response.data;
            Alert.alert(response.status, response.msg);
        })
    }

    render() {
        return (
            <View style={styles.container}>
                <View style={styles.header}>
                    <Text style={{ color: 'white', textAlign: 'center', fontSize: 28 }}>REWARDS E-VOUCHER</Text>
                </View>
                <ScrollView style={styles.body}>
                    {
                        this.state.rewardsList.map((item, key) => (
                            <TouchableOpacity key={key} onPress={() => this.props.navigation.navigate('Reward Detail', { rewardId: item.id })}>
                                <View style={{ alignItems: 'center' }}>
                                    <Card style={{ padding: 5, margin: 10 }}>
                                        <View>
                                            <Image source={{ uri: item.reward.title_image }}
                                                resizeMethod="resize"
                                                resizeMode='stretch'
                                                style={{ height: 150, width: 430 }} />
                                        </View>
                                        <View style={{ flexDirection: 'row', justifyContent:'space-between', padding:10 }}>
                                            <View>
                                                <Text style={{fontWeight:'bold'}}>{item.reward.title}</Text>
                                                <Text>{item.reward.subtitle}</Text>
                                            </View>
                                            <View>
                                                <Text style={{textAlign:'right'}}>Expired</Text>
                                                <Text style={{textAlign:'right'}}>{item.expire_time}</Text>
                                            </View>
                                        </View>
                                    </Card>
                                </View>
                            </TouchableOpacity>
                        ))
                    }
                    <TouchableOpacity>
                        <Text style={{ textAlign: 'right', color: '#ccb46c' }}>REDEEM E-VOUCHER HISTORY</Text>
                    </TouchableOpacity>
                </ScrollView>
            </View>
        )
    }
}

const styles = StyleSheet.create({
    container: {
        flex: 1,
        backgroundColor: 'white',
    },
    header: {
        flex: 0.1,
        backgroundColor: '#ccb46c',
        justifyContent: 'center'
    },

    body: {
        flex: 3,
    },
    list_detail_order: {
        flex: 1,
        margin: 20,
        borderWidth: 1,
    }
})

const mapStateToProps = (state) => {
    return {

        session_id: state.session_id,

    }
}

export default connect(mapStateToProps)(RewardsList);