import React from 'react';
import { View, Text, TextInput, StyleSheet, Button, Alert, TouchableOpacity, Image, Modal } from 'react-native';
import { connect } from 'react-redux';
import Axios from 'axios';
import ActionType from '../redux/globalActionType';
import Spinner from 'react-native-loading-spinner-overlay';
import PinRequest from './PinRequest'

class UseBalance extends React.Component {

    constructor(props) {
        super(props);
        this.state = {
            current_balance: 0,
            kaspro_point: 0,
            redeem_balance: 0,
            redeem_point: 0,
            modalVisible: false,
            pin: ''
        }
    }


    componentDidMount() {
        this._getProfile()
    }
    _getProfile() {
        let params = {
            session_id: this.props.session_id
        }

        Axios.post('https://excelsocrm.ravintoladev.com/crm/v2/member/get_profile', params).then(res => {
            console.log('ini res ' + JSON.stringify(res.data))
            const dataCard = res.data


            let balance = dataCard.kaspro_balance.replace(',', '')
            let point = dataCard.kaspro_point.replace(',', '')
            let balances = parseFloat(balance);
            let points = parseFloat(point);


            this.setState({
                current_balance: balances,
                kaspro_point: points
            })


        }).catch(error => {
            // console.log('ini error ' + error)
        })
    }

    handleBack() {
        this.setState({
            modalVisible: false
        })
    }

    handleSubmit() {
        this.redeem()
        this.setState({
            modalVisible: false,
            pin: '',
        })
    }
    modal() {
        this.setState({
            modalVisible: true
        })
    }

    redeem() {
        if (this.state.redeem_balance > this.state.current_balance) {
            Alert.alert('', 'Maaf Balance tidak cukup')
        } else if (this.state.redeem_point > this.state.kaspro_point) {
            Alert.alert('', 'Maaf Point tidak cukup')
        } else {
            let params = {
                session_id: this.props.session_id,
                pin: this.state.pin,
                balance: this.state.redeem_balance,
                point: this.state.redeem_point
            }

            Axios.post('https://excelsocrm.ravintoladev.com/crm/v2/point/redeem', params).then(res => {
                Alert.alert('', 'Sukses Redeem')
            }).catch(error => {
                let response = error.response.data
                if (response.code === "EMPTY_PIN") {
                    this.modal()
                } else {
                    let response = error.response.data;
                    Alert.alert('', response.msg);
                }

            })
        }
    }

    render() {
        return (
            <View style={styles.container}>
                <Modal animationType="slide"
                    transparent={false}
                    visible={this.state.modalVisible}
                    onRequestClose={() => {
                        this.setState({
                            modalVisible: false
                        })
                    }}>

                    <PinRequest />

                    {/* <View style={styles.centerViewModal}>
                        <View style={styles.modalView}>
                            <Text style={{ fontSize: 12, color: '#CFB368', fontFamily: 'Gotham-Black' }}>PIN</Text>
                            <View style={{ margin: 10 }}>
                                <TextInput
                                    style={styles.textInput}
                                    onChangeText={(pin) => this.setState({ pin })}
                                    value={this.state.pin}
                                    textAlign='center'
                                />
                            </View>
                            <View>
                            </View>
                            <View style={{margin:5}}>
                                <TouchableOpacity style={{marginBottom:10}} onPress={() => this.handleSubmit()}>
                                    <View style={styles.button2}>
                                        <Text style={{ color: 'white', fontWeight: 'bold', fontSize: 16 }}>submit</Text>
                                    </View>
                                </TouchableOpacity>
                                <TouchableOpacity onPress={() => this.handleBack()}>
                                    <View style={styles.button2}>
                                        <Text style={{ color: 'white', fontWeight: 'bold', fontSize: 16 }}>Back</Text>
                                    </View>
                                </TouchableOpacity>
                            </View>
                        </View>
                    </View> */}

                </Modal>
                <View style={{ flex: 3 }}>
                    <View style={{ flex: 1, marginRight: 30, marginLeft: 30, top: 50 }}>
                        <Text style={{ fontFamily: 'Gotham-Black', color: '#CFB368', fontSize: 20, textAlign: 'center', margin: 3 }}>Current Balance</Text>
                        <TextInput style={{ height: 40, borderWidth: 1, padding: 5, margin: 10, borderRadius: 10, borderColor: 'grey', fontFamily: 'Gotham-Black', textAlign: 'center', color: 'grey', fontWeight: 'bold', fontSize: 20 }}
                            onChangeText={(redeem_balance) => this.setState({ redeem_balance })}
                            keyboardType='numeric'>{this.state.current_balance}</TextInput>
                        <Text style={{ fontFamily: 'Gotham-Black', color: '#CFB368', fontSize: 20, textAlign: 'center', margin: 3 }}>Redeem</Text>
                        <TextInput style={{ height: 40, borderWidth: 1, padding: 5, margin: 10, borderRadius: 10, borderColor: 'grey', fontFamily: 'Gotham-Black', textAlign: 'center', color: 'grey', fontWeight: 'bold', fontSize: 20 }}
                            onChangeText={(redeem_point) => this.setState({ redeem_point })}
                            autoCapitalize="none"
                            keyboardType='numeric'>{this.state.kaspro_point}</TextInput>
                        <TouchableOpacity style={{ height: 100 }} onPress={() => this.redeem()}>
                            <View style={{ backgroundColor: '#CFB368', height: 40, top: 20, borderRadius: 10, marginRight: 50, marginLeft: 50 }}>
                                <Text style={{ alignSelf: 'center', top: 10, color: 'white', fontFamily: 'Gotham-Black', fontSize: 20 }}>REDEEM</Text>
                            </View>
                        </TouchableOpacity>
                    </View>
                </View>
            </View>
        )
    }
}

const styles = StyleSheet.create({

    container: {
        flex: 1,
        backgroundColor: '#ffff'
    },

    header: {
        flex: 0.5,
        margin: 10,
    },

    form: {
        flex: 3,
        top: 40,
        margin: 10,
        marginTop: 0,
    },

    field_email: {
        flexDirection: 'row'
    },

    button: {
        height: 40,
        margin: 10,

    },
    logo: {
        alignSelf: 'flex-start',
        marginTop: 50,
        width: 290,
        height: 290,
        bottom: 145,

    },
    v_logo: {
        flex: 2,
        flexDirection: 'column-reverse',
        alignContent: 'flex-start',
    },
    centerViewModal: {
        flex: 1,
        justifyContent: "center",
        alignItems: "center",
    },
    modalView: {
        backgroundColor: "white",
        borderRadius: 10,
        borderWidth: 1,
        borderColor: 'grey',
        padding: 20,
        alignItems: "center",
    },
    textInput: {
        height: 40,
        width: 250,
        borderColor: 'gray',
        borderWidth: 1,
        marginHorizontal: 30,
        borderRadius: 10
    },
    button2: {
        backgroundColor: '#CFB368',
        padding: 20,
        height: 40,
        borderRadius: 10,
        paddingVertical: 5,
        alignItems: 'center',
        justifyContent: 'center'
    },
})

const mapStateToProps = (state) => {
    return {
        session_id: state.session_id,
        language: state.language,
        pageEmailConfirmation: state.pageEmailConfirmation
    }
}

export default connect(mapStateToProps)(UseBalance);
